/*
 * Decompiled with CFR 0.152.
 */
package projects.motifComp;

import de.jstacs.clustering.hierachical.ClusterTree;
import de.jstacs.data.DeBruijnSequenceGenerator;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.CyclicSequenceAdaptor;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.sequenceScores.statisticalModels.StatisticalModel;
import de.jstacs.utils.PFMComparator;
import de.jstacs.utils.Pair;
import projects.motifComp.PFMWrapperTrainSM;

public class DeBruijnMotifComparison {
    public static Pair<Integer, Double> compare(double[][] profiles1, double[][] profiles2, int maxShift) throws Exception {
        double max = Double.NEGATIVE_INFINITY;
        int maxOff = 0;
        double[] fullStat = DeBruijnMotifComparison.getStatistics(profiles1, profiles2, 0, 0, profiles1[0].length, profiles2[0].length);
        double n = 0.0;
        int i = 0;
        while (i <= maxShift) {
            n = profiles1.length * (profiles1[0].length - i);
            double[] prevStat1 = DeBruijnMotifComparison.getStatistics(profiles1, profiles2, 0, 0, 0, i);
            double[] prevStat2 = DeBruijnMotifComparison.getStatistics(profiles1, profiles2, 0, 0, i, 0);
            double[] postStat1 = DeBruijnMotifComparison.getStatistics(profiles1, profiles2, profiles1[0].length - i, profiles2[0].length, profiles1[0].length, profiles2[0].length);
            double[] postStat2 = DeBruijnMotifComparison.getStatistics(profiles1, profiles2, profiles1[0].length, profiles2[0].length - i, profiles1[0].length, profiles2[0].length);
            double[] currStat1 = DeBruijnMotifComparison.getCurr(fullStat, prevStat1, postStat1);
            double[] currStat2 = DeBruijnMotifComparison.getCurr(fullStat, prevStat2, postStat2);
            double currCross1 = DeBruijnMotifComparison.getCross(profiles1, profiles2, 0, i, profiles1[0].length - i, profiles2[0].length);
            double currCross2 = DeBruijnMotifComparison.getCross(profiles1, profiles2, i, 0, profiles1[0].length, profiles2[0].length - i);
            double cov1 = currCross1 / n - currStat1[0] / n * currStat1[1] / n;
            double cov2 = currCross2 / n - currStat2[0] / n * currStat2[1] / n;
            double sd11 = Math.sqrt(currStat1[2] / n - currStat1[0] / n * currStat1[0] / n);
            double sd12 = Math.sqrt(currStat1[3] / n - currStat1[1] / n * currStat1[1] / n);
            double sd21 = Math.sqrt(currStat2[2] / n - currStat2[0] / n * currStat2[0] / n);
            double sd22 = Math.sqrt(currStat2[3] / n - currStat2[1] / n * currStat2[1] / n);
            double corr1 = cov1 / (sd11 * sd12);
            double corr2 = cov2 / (sd21 * sd22);
            if (corr1 > max) {
                max = corr1;
                maxOff = i;
            }
            if (corr2 > max) {
                max = corr2;
                maxOff = -i;
            }
            ++i;
        }
        return new Pair<Integer, Double>(maxOff, max);
    }

    private static final double getCross(double[][] profiles1, double[][] profiles2, int start1, int start2, int end1, int end2) {
        double cross = 0.0;
        int i = 0;
        while (i < profiles1.length) {
            int j = start1;
            int k = start2;
            while (j < end1 && k < end2) {
                cross += profiles1[i][j] * profiles2[i][k];
                ++j;
                ++k;
            }
            ++i;
        }
        return cross;
    }

    private static final double[] getCurr(double[] fullStat, double[] prevStat, double[] postStat) {
        double[] curr = new double[fullStat.length];
        int i = 0;
        while (i < curr.length) {
            curr[i] = fullStat[i] - prevStat[i] - postStat[i];
            ++i;
        }
        return curr;
    }

    private static final double[] getStatistics(double[][] profiles1, double[][] profiles2, int start1, int start2, int end1, int end2) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sq1 = 0.0;
        double sq2 = 0.0;
        int k = 0;
        while (k < profiles1.length) {
            int i = start1;
            while (i < end1) {
                sum1 += profiles1[k][i];
                sq1 += profiles1[k][i] * profiles1[k][i];
                ++i;
            }
            int j = start2;
            while (j < end2) {
                sum2 += profiles2[k][j];
                sq2 += profiles2[k][j] * profiles2[k][j];
                ++j;
            }
            ++k;
        }
        return new double[]{sum1, sum2, sq1, sq2};
    }

    public static double[][] getProfilesForMotif(StatisticalModel model, int n, boolean revcom) throws Exception {
        CyclicSequenceAdaptor[] ad = DeBruijnSequenceGenerator.generate((DiscreteAlphabet)model.getAlphabetContainer().getAlphabetAt(0), n);
        return DeBruijnMotifComparison.getProfilesForMotif(ad, model, revcom);
    }

    public static double[][] getProfilesForMotif(CyclicSequenceAdaptor[] ad, StatisticalModel model, boolean revcom) throws Exception {
        double[][] profiles = new double[ad.length][];
        int i = 0;
        while (i < ad.length) {
            Sequence seq = ad[i];
            if (revcom) {
                seq = ((CyclicSequenceAdaptor)seq).reverseComplement();
            }
            int origLength = ((CyclicSequenceAdaptor)seq).getLength();
            seq = ((CyclicSequenceAdaptor)seq).getSuperSequence(((CyclicSequenceAdaptor)seq).getLength() + model.getLength() - 1);
            profiles[i] = new double[((CyclicSequenceAdaptor)seq).getLength()];
            int j = 0;
            while (j < ((CyclicSequenceAdaptor)seq).getLength()) {
                profiles[i][j] = revcom ? (j + model.getLength() < origLength ? Math.exp(model.getLogProbFor(seq, origLength - j - model.getLength(), origLength - j - 1)) : Math.exp(model.getLogProbFor(seq, ((CyclicSequenceAdaptor)seq).getLength() - j - 1, ((CyclicSequenceAdaptor)seq).getLength() - j - 1 + model.getLength() - 1))) : Math.exp(model.getLogProbFor(seq, j, j + model.getLength() - 1));
                ++j;
            }
            ++i;
        }
        return profiles;
    }

    public static double[][][] getClusterRepresentatives(ClusterTree<StatisticalModel>[] trees, int n) throws Exception {
        double[][][] reps = new double[trees.length][][];
        int i = 0;
        while (i < trees.length) {
            reps[i] = DeBruijnMotifComparison.getClusterRepresentative(trees[i], n);
            ++i;
        }
        return reps;
    }

    public static double[][] getClusterRepresentative(ClusterTree<StatisticalModel> tree, int n) throws Exception {
        if (tree.getNumberOfElements() == 1) {
            if (tree.getClusterElements()[0] instanceof PFMWrapperTrainSM) {
                return ((PFMWrapperTrainSM)tree.getClusterElements()[0]).getPWM();
            }
            return null;
        }
        ClusterTree<StatisticalModel>[] subs = tree.getSubTrees();
        double[][][] reps = new double[subs.length][][];
        int i = 0;
        while (i < subs.length) {
            reps[i] = DeBruijnMotifComparison.getClusterRepresentative(subs[i], n);
            ++i;
        }
        double[][] rep = reps[0];
        double n1 = subs[0].getNumberOfElements();
        int i2 = 1;
        while (i2 < reps.length) {
            PFMWrapperTrainSM model = new PFMWrapperTrainSM(DNAAlphabetContainer.SINGLETON, null, rep, 0.0);
            double[][] prof1 = DeBruijnMotifComparison.getProfilesForMotif(model, n, false);
            PFMWrapperTrainSM model2 = new PFMWrapperTrainSM(DNAAlphabetContainer.SINGLETON, null, reps[i2], 0.0);
            double[][] prof2 = DeBruijnMotifComparison.getProfilesForMotif(model2, n, false);
            double[][] prof2Rc = DeBruijnMotifComparison.getProfilesForMotif(model2, n, true);
            Pair<Integer, Double> fwd = DeBruijnMotifComparison.compare(prof1, prof2, Math.max(rep.length - (int)Math.floor(reps[i2].length), reps[i2].length - (int)Math.floor(reps.length)));
            Pair<Integer, Double> rev = DeBruijnMotifComparison.compare(prof1, prof2Rc, Math.max(rep.length - (int)Math.floor(reps[i2].length), reps[i2].length - (int)Math.floor(reps.length)));
            int shift = fwd.getFirstElement();
            double[][] mat = (double[][])ArrayHandler.clone((Cloneable[])reps[i2]);
            if (fwd.getSecondElement() < rev.getSecondElement()) {
                shift = rev.getFirstElement();
                mat = PFMComparator.getReverseComplement(DNAAlphabet.SINGLETON, mat);
            }
            int totL = shift >= 0 ? Math.max(rep.length, mat.length + shift) : Math.max(rep.length - shift, mat.length);
            double[][] com = new double[totL][rep[0].length];
            double n2 = subs[i2].getNumberOfElements();
            int j = 0;
            while (j < com.length) {
                int k = 0;
                while (k < com[j].length) {
                    com[j][k] = shift >= 0 ? ((j < rep.length ? rep[j][k] : 0.25) * n1 + (j >= shift && j - shift < mat.length ? mat[j - shift][k] : 0.25) * n2) / (n1 + n2) : ((j >= -shift && j + shift < rep.length ? rep[j + shift][k] : 0.25) * n1 + (j < mat.length ? mat[j][k] : 0.25) * n2) / (n1 + n2);
                    ++k;
                }
                ++j;
            }
            n1 += n2;
            rep = com;
            ++i2;
        }
        return rep;
    }
}

