/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.charts;

import javax.swing.JFrame;
import org.jfree.chart.JFreeChart;
import umontreal.iro.lecuyer.charts.Axis;
import umontreal.iro.lecuyer.charts.SSJXYSeriesCollection;

public abstract class XYChart {
    protected Axis XAxis;
    protected Axis YAxis;
    protected SSJXYSeriesCollection dataset;
    protected JFreeChart chart;
    protected boolean latexDocFlag = true;
    protected boolean autoRange;
    protected double[] manualRange;
    protected boolean grid = false;
    protected double xstepGrid;
    protected double ystepGrid;
    protected double chartMargin = 0.05;

    public JFreeChart getJFreeChart() {
        return this.chart;
    }

    public Axis getXAxis() {
        return this.XAxis;
    }

    public Axis getYAxis() {
        return this.YAxis;
    }

    public abstract JFrame view(int var1, int var2);

    public String getTitle() {
        return this.chart.getTitle().getText();
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
    }

    public void setAutoRange(boolean right, boolean top) {
        this.setAutoRange(false, right, top);
    }

    public void setAutoRange() {
        this.setAutoRange(true, true, true);
    }

    private void setAutoRange(boolean flag00, boolean right, boolean top) {
        this.autoRange = true;
        double BorneMin = this.dataset.getDomainBounds()[0];
        BorneMin = BorneMin < 0.0 ? (BorneMin *= 1.0 + this.chartMargin) : (BorneMin *= 1.0 - this.chartMargin);
        double BorneMax = this.dataset.getDomainBounds()[1];
        BorneMax = BorneMax < 0.0 ? (BorneMax *= 1.0 - this.chartMargin) : (BorneMax *= 1.0 + this.chartMargin);
        this.XAxis.getAxis().setLowerBound(BorneMin);
        this.XAxis.getAxis().setUpperBound(BorneMax);
        BorneMin = this.dataset.getRangeBounds()[0];
        BorneMin = BorneMin < 0.0 ? (BorneMin *= 1.0 + this.chartMargin) : (BorneMin *= 1.0 - this.chartMargin);
        BorneMax = this.dataset.getRangeBounds()[1];
        BorneMax = BorneMax < 0.0 ? (BorneMax *= 1.0 - this.chartMargin) : (BorneMax *= 1.0 + this.chartMargin);
        this.YAxis.getAxis().setLowerBound(BorneMin);
        this.YAxis.getAxis().setUpperBound(BorneMax);
        if (!flag00) {
            if (right) {
                this.XAxis.setTwinAxisPosition(this.XAxis.getAxis().getLowerBound());
            } else {
                this.XAxis.setTwinAxisPosition(this.XAxis.getAxis().getUpperBound());
            }
            if (top) {
                this.YAxis.setTwinAxisPosition(this.YAxis.getAxis().getLowerBound());
            } else {
                this.YAxis.setTwinAxisPosition(this.YAxis.getAxis().getUpperBound());
            }
        }
    }

    public void setManualRange(double[] range, boolean right, boolean top) {
        this.setManualRange(range, false, right, top);
    }

    public void setManualRange(double[] range) {
        this.setManualRange(range, true, true, true);
    }

    private void setManualRange(double[] range, boolean flag00, boolean right, boolean top) {
        if (range.length != 4) {
            throw new IllegalArgumentException("range must have the format: [xmin, xmax, ymin, ymax]");
        }
        this.autoRange = false;
        this.XAxis.getAxis().setLowerBound(Math.min(range[0], range[1]));
        this.XAxis.getAxis().setUpperBound(Math.max(range[0], range[1]));
        this.YAxis.getAxis().setLowerBound(Math.min(range[2], range[3]));
        this.YAxis.getAxis().setUpperBound(Math.max(range[2], range[3]));
        if (!flag00) {
            if (right) {
                this.XAxis.setTwinAxisPosition(this.XAxis.getAxis().getLowerBound());
            } else {
                this.XAxis.setTwinAxisPosition(this.XAxis.getAxis().getUpperBound());
            }
            if (top) {
                this.YAxis.setTwinAxisPosition(this.YAxis.getAxis().getLowerBound());
            } else {
                this.YAxis.setTwinAxisPosition(this.YAxis.getAxis().getUpperBound());
            }
        }
    }

    public double getChartMargin() {
        return this.chartMargin;
    }

    public void setChartMargin(double margin) {
        if (margin < 0.0) {
            throw new IllegalArgumentException("margin < 0");
        }
        this.chartMargin = margin;
    }

    public abstract void setTicksSynchro(int var1);

    public void enableGrid(double xstep, double ystep) {
        this.grid = true;
        this.xstepGrid = xstep;
        this.ystepGrid = ystep;
    }

    public void disableGrid() {
        this.grid = false;
    }

    public abstract String toLatex(double var1, double var3);

    public void setLatexDocFlag(boolean flag) {
        this.latexDocFlag = flag;
    }

    protected double computeXScale(double position) {
        double[] bounds = new double[]{this.XAxis.getAxis().getLowerBound(), this.XAxis.getAxis().getUpperBound()};
        if (position < bounds[0]) {
            bounds[0] = position;
        }
        if (position > bounds[1]) {
            bounds[1] = position;
        }
        bounds[0] = bounds[0] - position;
        bounds[1] = bounds[1] - position;
        return this.computeScale(bounds);
    }

    protected double computeYScale(double position) {
        double[] bounds = new double[]{this.YAxis.getAxis().getLowerBound(), this.YAxis.getAxis().getUpperBound()};
        if (position < bounds[0]) {
            bounds[0] = position;
        }
        if (position > bounds[1]) {
            bounds[1] = position;
        }
        bounds[0] = bounds[0] - position;
        bounds[1] = bounds[1] - position;
        return this.computeScale(bounds);
    }

    protected double computeScale(double[] bounds) {
        int tenPowerRatio = 0;
        while (bounds[1] > 1000.0 || bounds[0] < -1000.0) {
            bounds[1] = bounds[1] / 10.0;
            bounds[0] = bounds[0] / 10.0;
            ++tenPowerRatio;
        }
        while (bounds[1] < 100.0 && bounds[0] > -100.0) {
            bounds[1] = bounds[1] * 10.0;
            bounds[0] = bounds[0] * 10.0;
            --tenPowerRatio;
        }
        return 1.0 / Math.pow(10.0, tenPowerRatio);
    }
}

