/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class TriangularDist
extends ContinuousDistribution {
    private double a;
    private double b;
    private double m;

    public TriangularDist() {
        this.setParams(0.0, 1.0, 0.5);
    }

    public TriangularDist(double m) {
        this.setParams(0.0, 1.0, m);
    }

    public TriangularDist(double a, double b, double m) {
        this.setParams(a, b, m);
    }

    public double density(double x) {
        return TriangularDist.density(this.a, this.b, this.m, x);
    }

    public double cdf(double x) {
        return TriangularDist.cdf(this.a, this.b, this.m, x);
    }

    public double barF(double x) {
        return TriangularDist.barF(this.a, this.b, this.m, x);
    }

    public double inverseF(double u) {
        return TriangularDist.inverseF(this.a, this.b, this.m, u);
    }

    public double getMean() {
        return TriangularDist.getMean(this.a, this.b, this.m);
    }

    public double getVariance() {
        return TriangularDist.getVariance(this.a, this.b, this.m);
    }

    public double getStandardDeviation() {
        return TriangularDist.getStandardDeviation(this.a, this.b, this.m);
    }

    public static double density(double a, double b, double m, double x) {
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (x < a || x > b) {
            return 0.0;
        }
        if (x <= m && m != a) {
            return 2.0 * (x - a) / ((b - a) * (m - a));
        }
        return 2.0 * (b - x) / ((b - a) * (b - m));
    }

    public static double cdf(double a, double b, double m, double x) {
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (x < a) {
            return 0.0;
        }
        if (x <= m && m != a) {
            return (x - a) * (x - a) / ((b - a) * (m - a));
        }
        if (x <= b) {
            return 1.0 - (b - x) * (b - x) / ((b - a) * (b - m));
        }
        return 1.0;
    }

    public static double barF(double a, double b, double m, double x) {
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (x <= a) {
            return 1.0;
        }
        if (x <= m && m != a) {
            return 1.0 - (x - a) * (x - a) / ((b - a) * (m - a));
        }
        if (x <= b) {
            return (b - x) * (b - x) / ((b - a) * (b - m));
        }
        return 0.0;
    }

    public static double inverseF(double a, double b, double m, double u) {
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (u <= 0.0) {
            return a;
        }
        if (u >= 1.0) {
            return b;
        }
        double h = (m - a) / (b - a);
        return u <= h && m != a ? a + Math.sqrt((b - a) * (m - a) * u) : b - Math.sqrt((b - a) * (b - m) * (1.0 - u));
    }

    public static double getMean(double a, double b, double m) {
        if (a == 0.0 && b == 1.0 && (m < 0.0 || m > 1.0)) {
            throw new IllegalArgumentException("m is not in [0,1]");
        }
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        return (a + b + m) / 3.0;
    }

    public static double getVariance(double a, double b, double m) {
        if (a == 0.0 && b == 1.0 && (m < 0.0 || m > 1.0)) {
            throw new IllegalArgumentException("m is not in [0,1]");
        }
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        return (a * a + b * b + m * m - a * b - a * m - b * m) / 18.0;
    }

    public static double getStandardDeviation(double a, double b, double m) {
        return Math.sqrt(TriangularDist.getVariance(a, b, m));
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getM() {
        return this.m;
    }

    public void setParams(double a, double b, double m) {
        if (a == 0.0 && b == 1.0 && (m < 0.0 || m > 1.0)) {
            throw new IllegalArgumentException("m is not in [0,1]");
        }
        if (a >= b) {
            throw new IllegalArgumentException("a >= b");
        }
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        this.a = a;
        this.b = b;
        this.m = m;
        this.supportA = a;
        this.supportB = b;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.a, this.b, this.m};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + " : a = " + this.a + ", b = " + this.b + ", m = " + this.m;
    }
}

