/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.probdist.BetaSymmetricalDist;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.randvar.BetaSymmetricalGen;
import umontreal.iro.lecuyer.randvar.GammaGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.GammaProcessBridge;

public class GammaProcessSymmetricalBridge
extends GammaProcessBridge {
    protected BetaSymmetricalGen BSgen;

    public GammaProcessSymmetricalBridge(double s0, double mu, double nu, RandomStream stream) {
        this(s0, mu, nu, new GammaGen(stream, new GammaDist(1.0)), new BetaSymmetricalGen(stream, new BetaSymmetricalDist(1.0)));
    }

    public GammaProcessSymmetricalBridge(double s0, double mu, double nu, GammaGen Ggen, BetaSymmetricalGen BSgen) {
        super(s0, mu, nu, Ggen, BSgen);
        this.BSgen = BSgen;
        BSgen.setStream(Ggen.getStream());
    }

    public double nextObservation() {
        double s;
        if (this.bridgeCounter == -1) {
            s = this.x0 + GammaGen.nextDouble(this.stream, this.mu2dTOverNu, this.muOverNu);
            this.bridgeCounter = 0;
            this.observationIndex = this.d;
        } else {
            int j = this.bridgeCounter * 3;
            int oldIndexL = this.wIndexList[j];
            int newIndex = this.wIndexList[j + 1];
            int oldIndexR = this.wIndexList[j + 2];
            double y = BetaSymmetricalGen.nextDouble(this.stream, this.bMu2dtOverNuL[newIndex]);
            s = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) * y;
            ++this.bridgeCounter;
            this.observationIndex = newIndex;
        }
        this.observationCounter = this.bridgeCounter + 1;
        this.path[this.observationIndex] = s;
        return s;
    }

    public double nextObservation(double nextT) {
        double s;
        if (this.bridgeCounter == -1) {
            this.t[this.d] = nextT;
            this.mu2dTOverNu = this.mu2OverNu * (this.t[this.d] - this.t[0]);
            s = this.x0 + GammaGen.nextDouble(this.stream, this.mu2dTOverNu, this.muOverNu);
            this.bridgeCounter = 0;
            this.observationIndex = this.d;
        } else {
            int j = this.bridgeCounter * 3;
            int oldIndexL = this.wIndexList[j];
            int newIndex = this.wIndexList[j + 1];
            int oldIndexR = this.wIndexList[j + 2];
            this.t[newIndex] = nextT;
            this.bMu2dtOverNuL[newIndex] = this.mu2OverNu * (this.t[newIndex] - this.t[oldIndexL]);
            double y = BetaSymmetricalGen.nextDouble(this.stream, this.bMu2dtOverNuL[newIndex]);
            s = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) * y;
            ++this.bridgeCounter;
            this.observationIndex = newIndex;
        }
        this.observationCounter = this.bridgeCounter + 1;
        this.path[this.observationIndex] = s;
        return s;
    }

    public double[] generatePath() {
        this.path[this.d] = this.x0 + GammaGen.nextDouble(this.stream, this.mu2dTOverNu, this.muOverNu);
        for (int j = 0; j < 3 * (this.d - 1); j += 3) {
            int oldIndexL = this.wIndexList[j];
            int newIndex = this.wIndexList[j + 1];
            int oldIndexR = this.wIndexList[j + 2];
            double y = BetaSymmetricalGen.nextDouble(this.stream, this.bMu2dtOverNuL[newIndex]);
            this.path[newIndex] = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) * y;
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath(double[] uniform01) {
        this.path[this.d] = this.x0 + GammaDist.inverseF(this.mu2dTOverNu, this.muOverNu, 15, uniform01[0]);
        for (int j = 0; j < 3 * (this.d - 1); j += 3) {
            int oldIndexL = this.wIndexList[j];
            int newIndex = this.wIndexList[j + 1];
            int oldIndexR = this.wIndexList[j + 2];
            double y = BetaSymmetricalDist.inverseF(this.bMu2dtOverNuL[newIndex], uniform01[1 + j / 3]);
            this.path[newIndex] = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) * y;
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    protected void init() {
        super.init();
        if (this.observationTimesSet) {
            int k = 0;
            int x = this.d;
            int y = 1;
            while (x > 1) {
                x /= 2;
                y *= 2;
                ++k;
            }
            if (y != this.d) {
                throw new IllegalArgumentException("GammaProcessSymmetricalBridge:Number 'n' of observation times is not a power of 2");
            }
            boolean equidistant = true;
            double macheps = 1.0E-13;
            double dt = this.t[1] - this.t[0];
            for (int i = 1; i < this.d; ++i) {
                if (this.t[i + 1] - this.t[i] == dt) continue;
                equidistant = false;
                if (dt == 0.0 || !(Math.abs(this.t[i + 1] - this.t[i] - dt) / dt <= macheps)) continue;
                equidistant = true;
            }
            if (!equidistant) {
                throw new IllegalArgumentException("GammaProcessSymmetricalBridge:Observation times of sample paths are not equidistant");
            }
        }
    }
}

