/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.DNADataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.utils.Normalisation;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Forward {
    static final double[][] stacking = new double[][]{{-1.49, -2.19, -1.44, -1.72}, {-0.93, -1.82, -1.29, -1.44}, {-1.81, -2.55, -1.82, -2.19}, {-0.57, -1.81, -0.93, -1.49}};
    static final double R = 0.0019872041456665754;
    static final double[] binding = new double[]{0.64, 0.12, 0.12, 0.64};

    public static double[][] forward(Sequence seq) {
        int N = seq.getLength();
        double[][] f = new double[N + 1][2];
        f[0][0] = 0.0;
        f[0][1] = 0.0;
        f[1][0] = Normalisation.getLogSum(0.0, binding[seq.discreteVal(0)] + stacking[seq.discreteVal(0)][seq.discreteVal(1)]);
        f[1][1] = Normalisation.getLogSum(0.0, binding[seq.discreteVal(0)]);
        int i = 2;
        while (i < N) {
            f[i][0] = Normalisation.getLogSum(f[i - 1][0], f[i - 1][1] + binding[seq.discreteVal(i - 1)] + stacking[seq.discreteVal(i - 1)][seq.discreteVal(i)] + stacking[seq.discreteVal(i - 2)][seq.discreteVal(i - 1)]);
            f[i][1] = Normalisation.getLogSum(f[i - 1][0], f[i - 1][1] + binding[seq.discreteVal(i - 1)] + stacking[seq.discreteVal(i - 2)][seq.discreteVal(i - 1)]);
            ++i;
        }
        f[N][0] = Normalisation.getLogSum(f[N - 1][0], f[N - 1][1] + binding[seq.discreteVal(N - 1)] + stacking[seq.discreteVal(N - 2)][seq.discreteVal(N - 1)]);
        f[N][1] = f[N][0];
        return f;
    }

    public static double[][] backward(Sequence seq) {
        int N = seq.getLength();
        double[][] b = new double[N + 1][2];
        b[N][0] = 0.0;
        b[N][1] = 0.0;
        b[N - 1][0] = 0.0;
        b[N - 1][1] = Normalisation.getLogSum(binding[seq.discreteVal(N - 1)] + stacking[seq.discreteVal(N - 2)][seq.discreteVal(N - 1)]);
        int i = N - 2;
        while (i >= 1) {
            b[i][0] = Normalisation.getLogSum(b[i + 1][0], b[i + 1][1]);
            b[i][1] = Normalisation.getLogSum(b[i + 1][0] + binding[seq.discreteVal(i)] + stacking[seq.discreteVal(i)][seq.discreteVal(i + 1)] + stacking[seq.discreteVal(i - 1)][seq.discreteVal(i)], b[i + 1][1] + binding[seq.discreteVal(i)] + stacking[seq.discreteVal(i - 1)][seq.discreteVal(i)]);
            --i;
        }
        b[0][0] = Normalisation.getLogSum(b[1][0], b[1][1]);
        b[0][1] = Normalisation.getLogSum(b[1][0] + binding[seq.discreteVal(0)] + stacking[seq.discreteVal(0)][seq.discreteVal(1)], b[1][1] + binding[seq.discreteVal(0)]);
        return b;
    }

    public static void main(String[] args) throws FileNotFoundException, WrongAlphabetException, EmptyDataSetException, WrongLengthException, IOException {
        double T = 310.15;
        int i = 0;
        while (i < stacking.length) {
            int j = 0;
            while (j < stacking[i].length) {
                double[] dArray = stacking[i];
                int n = j++;
                dArray[n] = dArray[n] / (0.0019872041456665754 * T);
            }
            int n = i++;
            binding[n] = binding[n] / (0.0019872041456665754 * T);
        }
        DNADataSet data = new DNADataSet("C:\\Users\\....\\hspromoter.fasta");
        int i2 = 0;
        while (i2 < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(i2);
            int j = 0;
            while (j < seq.getLength()) {
                seq.discreteVal(j);
                ++j;
            }
            ++i2;
        }
        double[][] P = null;
        int i3 = 0;
        while (i3 < data.getNumberOfElements()) {
            double[][] f = Forward.forward(data.getElementAt(i3));
            double[][] b = Forward.backward(data.getElementAt(i3));
            Sequence seq = data.getElementAt(i3);
            int n = 1;
            while (n < seq.getLength() - 2) {
                int k = 4;
                double znk = f[n - 1][1] + b[n + k - 2][1];
                int l = 0;
                while (l <= k - 2) {
                    znk += binding[seq.discreteVal(n + l - 1)] + stacking[seq.discreteVal(n + l - 1)][seq.discreteVal(n + l)];
                    ++l;
                }
                double pnk = Math.exp(znk -= f[f.length - 1][0]) / Math.exp(f[f.length - 1][0]);
                if (n == 1) {
                    P = new double[data.getNumberOfElements()][seq.getLength()];
                }
                P[i3][n] = pnk;
                ++n;
            }
            ++i3;
        }
        i3 = 0;
        Sequence seq = data.getElementAt(i3);
        int n = 1;
        while (n < seq.getLength() - 2) {
            double mittel = 0.0;
            int j = 1;
            while (j < data.getNumberOfElements()) {
                mittel += P[j][n];
                ++j;
            }
            double[] arr = new double[seq.getLength()];
            arr[n] = mittel /= (double)data.getNumberOfElements();
            System.out.println(String.valueOf(mittel) + " , ");
            ++n;
        }
    }
}

