/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.alignment.cost;

import de.jstacs.algorithms.alignment.cost.Costs;
import de.jstacs.data.sequences.Sequence;

public class AffineCosts
implements Costs {
    private double start;
    private double elong;
    private Costs c;

    public AffineCosts(double start, Costs c) {
        this.c = c;
        this.elong = c.getGapCosts();
        if (start < 0.0 && -start > this.elong) {
            throw new IllegalArgumentException("Problem: start < 0 && -start > elong");
        }
        this.start = start;
    }

    public double getElongateCosts() {
        return this.elong;
    }

    public double getGapCostsFor(int length) {
        return this.start + (double)length * this.elong;
    }

    @Override
    public double getCostFor(Sequence s1, Sequence s2, int i, int j) {
        return this.c.getCostFor(s1, s2, i, j);
    }

    @Override
    public double getGapCosts() {
        return this.c.getGapCosts();
    }
}

