/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization;

import de.jstacs.algorithms.optimization.DifferentiableFunction;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;

public class NegativeDifferentiableFunction
extends DifferentiableFunction {
    private DifferentiableFunction f;

    public NegativeDifferentiableFunction(DifferentiableFunction f) {
        this.f = f;
    }

    @Override
    public double evaluateFunction(double[] x) throws DimensionException, EvaluationException {
        return -this.f.evaluateFunction(x);
    }

    @Override
    public int getDimensionOfScope() {
        return this.f.getDimensionOfScope();
    }

    @Override
    public double[] evaluateGradientOfFunction(double[] x) throws DimensionException, EvaluationException {
        double[] erg = this.f.evaluateGradientOfFunction(x);
        int counter = 0;
        while (counter < erg.length) {
            int n = counter++;
            erg[n] = erg[n] * -1.0;
        }
        return erg;
    }
}

