/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.AbstractStringExtractor;

public class InfixStringExtractor
extends AbstractStringExtractor {
    private AbstractStringExtractor se;
    private int start;
    private int end;

    public InfixStringExtractor(AbstractStringExtractor se, int start, int length) {
        super(se.ignore);
        this.se = se;
        this.start = start;
        this.end = start + length;
        this.annotation = "infix data set (start=" + start + ", length=" + length + ") of " + se.getAnnotation();
    }

    @Override
    public boolean hasMoreElements() {
        return this.se.hasMoreElements();
    }

    @Override
    public String nextElement() {
        return ((String)this.se.nextElement()).substring(this.start, this.end);
    }

    @Override
    public SequenceAnnotation[] getCurrentSequenceAnnotations() {
        return this.se.getCurrentSequenceAnnotations();
    }
}

