/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters.validation;

import de.jstacs.Storable;
import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.validation.ParameterValidator;
import de.jstacs.sequenceScores.statisticalModels.trainable.AbstractTrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;

public class StorableValidator
implements ParameterValidator {
    private String errorMessage;
    private Class clazz;
    private boolean trained;

    public StorableValidator(Class<? extends Storable> clazz, boolean trained) throws Exception {
        if (!AbstractTrainableStatisticalModel.class.isAssignableFrom(clazz) && !AbstractClassifier.class.isAssignableFrom(clazz)) {
            throw new Exception("Class is not a subtype of AbstractClassifier or AbstractTrainableStatisticalModel.");
        }
        this.clazz = clazz;
        this.trained = trained;
    }

    public StorableValidator(Class<? extends Storable> clazz) throws Exception {
        if (!Storable.class.isAssignableFrom(clazz)) {
            throw new Exception("Class is not a subtype of Storable");
        }
        this.clazz = clazz;
        this.trained = false;
    }

    public StorableValidator(StringBuffer buf) throws NonParsableException {
        this.fromXML(buf);
    }

    @Override
    public StorableValidator clone() throws CloneNotSupportedException {
        try {
            StorableValidator clone = null;
            clone = AbstractTrainableStatisticalModel.class.isAssignableFrom(this.clazz) || AbstractClassifier.class.isAssignableFrom(this.clazz) ? new StorableValidator(this.clazz, this.trained) : new StorableValidator(this.clazz);
            clone.errorMessage = this.errorMessage;
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getCause().getMessage());
        }
    }

    @Override
    public boolean checkValue(Object value) {
        String className;
        block17: {
            block18: {
                if (AbstractTrainableStatisticalModel.class.isAssignableFrom(this.clazz) && value instanceof AbstractTrainableStatisticalModel) {
                    if (!this.trained || ((TrainableStatisticalModel)value).isInitialized()) {
                        this.errorMessage = null;
                        return true;
                    }
                    this.errorMessage = "The model must be trained.";
                    return false;
                }
                if (AbstractClassifier.class.isAssignableFrom(this.clazz) && value instanceof AbstractClassifier) {
                    if (!this.trained || ((AbstractClassifier)value).isInitialized()) {
                        this.errorMessage = null;
                        return true;
                    }
                    this.errorMessage = "The classifier must be trained.";
                    return false;
                }
                StringBuffer buf = null;
                if (value instanceof FileParameter.FileRepresentation) {
                    String content = ((FileParameter.FileRepresentation)value).getContent();
                    buf = new StringBuffer(content);
                } else if (value instanceof String) {
                    buf = new StringBuffer((String)value);
                } else if (value instanceof StringBuffer) {
                    buf = (StringBuffer)value;
                }
                try {
                    buf = XMLParser.extractForTag(buf, "object");
                    className = XMLParser.extractObjectForTags(buf, "className", String.class);
                    Class<?> c = Class.forName(className);
                    if (!this.clazz.isAssignableFrom(c)) break block17;
                    boolean modelTrained = false;
                    if (AbstractTrainableStatisticalModel.class.isAssignableFrom(c)) {
                        TrainableStatisticalModel model = (TrainableStatisticalModel)c.getConstructor(StringBuffer.class).newInstance(buf);
                        modelTrained = model.isInitialized();
                    } else if (AbstractClassifier.class.isAssignableFrom(c)) {
                        AbstractClassifier classifier = (AbstractClassifier)c.getConstructor(StringBuffer.class).newInstance(buf);
                        modelTrained = classifier.isInitialized();
                    } else {
                        c.getConstructor(StringBuffer.class).newInstance(buf);
                    }
                    if (this.trained && !modelTrained) break block18;
                    this.errorMessage = null;
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.errorMessage = "The file could not be parsed: " + e.getCause();
                    return false;
                }
            }
            this.errorMessage = "The classifier must be trained.";
            return false;
        }
        this.errorMessage = "File content was not of the correct class " + this.clazz.getName() + " but of " + className;
        return false;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendObjectWithTags(buf, this.errorMessage, "errorMessage");
        XMLParser.appendObjectWithTags(buf, this.trained, "trained");
        XMLParser.appendObjectWithTags(buf, this.clazz.getName(), "class");
        XMLParser.addTags(buf, "TrainedValidator");
        return buf;
    }

    public void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "TrainedValidator");
        this.errorMessage = XMLParser.extractObjectForTags(representation, "errorMessage", String.class);
        this.trained = XMLParser.extractObjectForTags(representation, "trained", Boolean.TYPE);
        try {
            this.clazz = Class.forName(XMLParser.extractObjectForTags(representation, "class", String.class));
        }
        catch (Exception e) {
            throw new NonParsableException(e.getMessage());
        }
    }
}

