/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.PositionDiffSM;
import java.text.NumberFormat;

public abstract class DurationDiffSM
extends PositionDiffSM {
    protected double ess;
    protected int min;
    protected int max;
    protected int delta;
    private static final String XML_TAG = "DurationDiffSM";

    protected DurationDiffSM(int min, int max, double ess) {
        super(min, max);
        this.setMinMax(min, max);
        if (ess < 0.0) {
            throw new IllegalArgumentException("The given ess has to be non-negative.");
        }
        this.ess = ess;
        this.reset();
    }

    private void setMinMax(int min, int max) {
        this.min = min;
        if (min < 0) {
            throw new IllegalArgumentException("The given minimum is below 0.");
        }
        this.max = max;
        this.delta = max - min;
    }

    protected DurationDiffSM(StringBuffer source) throws NonParsableException {
        super(source);
        this.reset();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer b = super.toXML();
        XMLParser.appendObjectWithTags(b, this.max, "max");
        XMLParser.appendObjectWithTags(b, this.min, "min");
        XMLParser.appendObjectWithTags(b, this.ess, "ess");
        XMLParser.addTags(b, XML_TAG);
        return b;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        StringBuffer b = XMLParser.extractForTag(xml, XML_TAG);
        super.fromXML(b);
        this.setMinMax(XMLParser.extractObjectForTags(b, "min", Integer.TYPE), XMLParser.extractObjectForTags(b, "max", Integer.TYPE));
        this.ess = XMLParser.extractObjectForTags(b, "ess", Double.TYPE);
    }

    @Override
    public void reset() {
        this.internal[0] = this.min;
    }

    @Override
    public boolean next() {
        this.internal[0] = this.internal[0] + 1;
        return this.internal[0] <= this.max;
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 1;
    }

    @Override
    public final double getESS() {
        return this.ess;
    }

    @Override
    public boolean isPossible(int ... positions) {
        return positions != null && positions.length == 1 && positions[0] >= this.min && positions[0] <= this.max;
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    public int getNumberOfPossibilities() {
        return this.max - this.min + 1;
    }

    public abstract void initializeUniformly();

    public abstract void adjust(int[] var1, double[] var2);

    public void modify(int delta) {
        if (delta != 0) {
            this.setMinMax(this.min, this.max + delta);
            this.alphabets = new AlphabetContainer((Alphabet)new DiscreteAlphabet(this.min, this.max));
        }
    }

    @Override
    public final double getLogNormalizationConstant() {
        return 0.0;
    }

    @Override
    public final double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return Double.NEGATIVE_INFINITY;
    }

    protected abstract String getRNotation(String var1, NumberFormat var2);

    @Override
    public String toString(NumberFormat nf) {
        return this.getRNotation("p", nf);
    }
}

