/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous;

import de.jstacs.NotTrainedException;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.DGTrainSMParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.parameters.HomMMParameterSet;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.text.NumberFormat;
import java.util.Random;

public class HomogeneousMM
extends HomogeneousTrainSM {
    private HomogeneousTrainSM.HomCondProb[] condProb;
    private static final String XML_TAG = "HomogeneousMarkovModel";

    public HomogeneousMM(HomMMParameterSet params) throws CloneNotSupportedException, IllegalArgumentException, NonParsableException {
        super(params);
    }

    public HomogeneousMM(StringBuffer stringBuff) throws NonParsableException {
        super(stringBuff);
    }

    @Override
    public HomogeneousMM clone() throws CloneNotSupportedException {
        HomogeneousMM clone = (HomogeneousMM)super.clone();
        clone.condProb = clone.cloneHomProb(this.condProb);
        return clone;
    }

    @Override
    protected Sequence getRandomSequence(Random r, int length) throws WrongAlphabetException, WrongSequenceTypeException {
        int[] seq = new int[length];
        int j = 0;
        int val = 0;
        j = 0;
        while (j < this.order && j < length) {
            seq[j] = this.chooseFromDistr(this.condProb[j], val, val + this.powers[1] - 1, r.nextDouble());
            val = (val + seq[j]) * this.powers[1];
            ++j;
        }
        while (j < length) {
            seq[j] = this.chooseFromDistr(this.condProb[this.order], val, val + this.powers[1] - 1, r.nextDouble());
            val = (val + seq[j++]) % this.powers[this.order] * this.powers[1];
        }
        return new IntSequence(this.alphabets, seq);
    }

    @Override
    public String getInstanceName() {
        return "hMM(" + this.getMaximalMarkovOrder() + ") " + (this.getESS() == 0.0 ? "ML" : "MAP");
    }

    @Override
    public double getLogPriorTerm() throws Exception {
        if (!this.trained) {
            throw new NotTrainedException();
        }
        double p = 0.0;
        double ess = this.getESS();
        if (ess != 0.0) {
            int counter1 = 0;
            while (counter1 < this.condProb.length) {
                int anz1 = this.condProb[counter1].getNumberOfSpecificConstraints();
                double pot = ess / (double)anz1;
                p += (double)anz1 * (Gamma.logOfGamma((double)this.powers[1] * pot) / (double)this.powers[1] - Gamma.logOfGamma(pot));
                int counter2 = 0;
                while (counter2 < anz1) {
                    p += pot * this.condProb[counter1].getLnFreq(counter2);
                    ++counter2;
                }
                ++counter1;
            }
        }
        return p;
    }

    @Override
    protected double logProbFor(Sequence sequence, int startpos, int endpos) {
        if (endpos < startpos) {
            return 0.0;
        }
        int idx = sequence.discreteVal(startpos++);
        double erg = this.condProb[0].getLnFreq(idx);
        int i = 1;
        while (i < this.order && startpos <= endpos) {
            idx = idx * this.powers[1] + sequence.discreteVal(startpos++);
            erg += this.condProb[i].getLnFreq(idx);
            ++i;
        }
        while (startpos <= endpos) {
            idx = idx % this.powers[this.order] * this.powers[1] + sequence.discreteVal(startpos++);
            erg += this.condProb[this.order].getLnFreq(idx);
        }
        return erg;
    }

    @Override
    public String toString(NumberFormat nf) {
        String erg = "description: " + this.getDescription();
        if (this.trained) {
            erg = String.valueOf(erg) + "\n\nprobabilities:\n";
            int i = 0;
            while (i <= this.order) {
                erg = String.valueOf(erg) + this.condProb[i].getFreqInfo(this.alphabets, nf) + "\n";
                ++i;
            }
        }
        return erg;
    }

    @Override
    public void train(DataSet data, double[] weights) throws Exception {
        this.train(new DataSet[]{data}, new double[][]{weights});
    }

    @Override
    public void train(DataSet[] data, double[][] weights) throws Exception {
        if (data.length != weights.length) {
            throw new IllegalArgumentException("The constraint data.length == weights.length is not fulfilled.");
        }
        int i = 0;
        while (i < this.condProb.length) {
            this.condProb[i++].reset();
        }
        i = 0;
        while (i < data.length) {
            if (data[i] != null) {
                this.countHomogeneous(data[i], weights[i]);
            }
            ++i;
        }
        this.estimate();
    }

    @Override
    protected StringBuffer getFurtherModelInfos() {
        if (this.condProb != null) {
            StringBuffer xml = new StringBuffer(1000);
            XMLParser.appendObjectWithTags(xml, this.condProb, "condProb");
            return xml;
        }
        return null;
    }

    @Override
    protected String getXMLTag() {
        return XML_TAG;
    }

    @Override
    protected void set(DGTrainSMParameterSet params, boolean trained) throws CloneNotSupportedException, NonParsableException {
        super.set(params, trained);
        if (!trained) {
            int i = 0;
            this.condProb = new HomogeneousTrainSM.HomCondProb[this.order + 1];
            while (i < this.condProb.length) {
                int[] pos = new int[i + 1];
                int j = 0;
                while (j <= i) {
                    pos[j] = j;
                    j = (byte)(j + 1);
                }
                int k = this.powers[i] * this.powers[1];
                this.condProb[i] = new HomogeneousTrainSM.HomCondProb(this, pos, k);
                i = (byte)(i + 1);
            }
        }
    }

    @Override
    protected void setFurtherModelInfos(StringBuffer xml) throws NonParsableException {
        if (this.trained) {
            this.condProb = XMLParser.extractObjectAndAttributesForTags(xml, "condProb", null, null, HomogeneousTrainSM.HomCondProb[].class, HomogeneousTrainSM.class, this);
        }
    }

    private void countHomogeneous(DataSet data, double[] weights) throws WrongAlphabetException {
        int d = data.getNumberOfElements();
        if (weights != null && d != weights.length) {
            throw new IllegalArgumentException("The weights are not suitable for the data (wrong dimension).");
        }
        if (!this.alphabets.checkConsistency(data.getAlphabetContainer())) {
            throw new WrongAlphabetException("The alphabets of the model and the DataSet are not suitable.");
        }
        DataSet.ElementEnumerator ei = new DataSet.ElementEnumerator(data);
        double w = 1.0;
        int counter1 = 0;
        while (counter1 < d) {
            Sequence seq = ei.nextElement();
            int l = seq.getLength();
            int idx = 0;
            if (weights != null) {
                w = weights[counter1];
            }
            int lengthCounter = 0;
            while (lengthCounter < this.order && lengthCounter < l) {
                idx = idx * this.powers[1] + seq.discreteVal(lengthCounter);
                this.condProb[lengthCounter].add(idx, w);
                ++lengthCounter;
            }
            this.condProb[this.order].addAll(seq, w, lengthCounter, idx);
            ++counter1;
        }
    }

    private void estimate() {
        double ess = this.getESS();
        int i = 0;
        while (i < this.condProb.length) {
            this.condProb[i].estimate(ess);
            ++i;
        }
        this.trained = true;
    }
}

