/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.galaxy;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.ParameterValidator;
import de.jstacs.utils.galaxy.GalaxyAdaptor;

public class MultilineSimpleParameter
extends SimpleParameter {
    private static String[][] table = new String[][]{{"&", "__amp__"}, {"\"", "__quot__"}, {"'", "__apos__"}, {">", "__gt__"}, {"<", "__lt__"}, {"\n", "(__cn__|__cr__)+"}};

    public MultilineSimpleParameter(String name, String comment, boolean required, Object defaultVal) throws SimpleParameter.DatatypeNotValidException, SimpleParameter.IllegalValueException {
        super(DataType.STRING, name, comment, required, defaultVal);
    }

    public MultilineSimpleParameter(String name, String comment, boolean required, ParameterValidator validator, Object defaultVal) throws ParameterException {
        super(DataType.STRING, name, comment, required, validator, defaultVal);
    }

    public MultilineSimpleParameter(String name, String comment, boolean required, ParameterValidator validator) throws SimpleParameter.DatatypeNotValidException {
        super(DataType.STRING, name, comment, required, validator);
    }

    public MultilineSimpleParameter(String name, String comment, boolean required) throws SimpleParameter.DatatypeNotValidException {
        super(DataType.STRING, name, comment, required);
    }

    public MultilineSimpleParameter(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    public void toGalaxy(String namePrefix, String configPrefix, int depth, StringBuffer descBuffer, StringBuffer configBuffer, boolean addLine) throws Exception {
        namePrefix = String.valueOf(namePrefix) + "_" + GalaxyAdaptor.getLegalName(this.getName());
        StringBuffer buf = new StringBuffer();
        if (this.validator != null && this.validator instanceof GalaxyConvertible) {
            ((GalaxyConvertible)((Object)this.validator)).toGalaxy(String.valueOf(namePrefix) + "_valid", null, depth, buf, null, false);
        }
        String line = "";
        if (addLine) {
            line = "&lt;hr /&gt;";
        }
        XMLParser.addTagsAndAttributes(buf, "param", "type=\"text\" area=\"true\" size=\"10x80\" name=\"" + namePrefix + "\" label=\"" + line + this.getName() + "\" help=\"" + this.getComment() + "\" value=\"" + (this.defaultValue == null ? "" : this.defaultValue) + "\" optional=\"" + !this.isRequired() + "\"");
        descBuffer.append(buf);
        buf = new StringBuffer();
        buf.append("${" + configPrefix + namePrefix + "}");
        XMLParser.addTags(buf, namePrefix);
        configBuffer.append(buf);
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
        namePrefix = String.valueOf(namePrefix) + "_" + GalaxyAdaptor.getLegalName(this.getName());
        String val = XMLParser.extractForTag(command, namePrefix).toString();
        val = MultilineSimpleParameter.unescape(val);
        this.setValue(val);
    }

    private static String unescape(String original) {
        if (original != null) {
            int i = 0;
            while (i < table.length) {
                original = original.replaceAll(table[i][1], table[i][0]);
                ++i;
            }
        }
        return original;
    }
}

