/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

public class Tridiagonal {
    private Tridiagonal() {
    }

    public static void transform(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4) {
        int n;
        int n2;
        int n3 = dArray.length;
        if (dArray != dArray2) {
            for (n2 = 0; n2 < n3; ++n2) {
                System.arraycopy(dArray[n2], 0, dArray2[n2], 0, n3);
            }
        }
        for (n2 = n3 - 1; n2 >= 1; --n2) {
            n = n2 - 1;
            double d = 0.0;
            if (n > 1) {
                int n4;
                double d2 = 0.0;
                for (n4 = 0; n4 <= n; ++n4) {
                    d2 += Math.abs(dArray2[n2][n4]);
                }
                if (d2 == 0.0) {
                    dArray4[n2] = dArray2[n2][n];
                } else {
                    for (n4 = 0; n4 <= n; ++n4) {
                        double[] dArray5 = dArray2[n2];
                        int n5 = n4;
                        dArray5[n5] = dArray5[n5] / d2;
                        d += dArray2[n2][n4] * dArray2[n2][n4];
                    }
                    double d3 = dArray2[n2][n];
                    double d4 = d3 >= 0.0 ? -Math.sqrt(d) : Math.sqrt(d);
                    dArray4[n2] = d2 * d4;
                    dArray2[n2][n] = d3 - d4;
                    d -= d3 * d4;
                    double d5 = 0.0;
                    for (int i = 0; i <= n; ++i) {
                        int n6;
                        dArray2[i][n2] = dArray2[n2][i] / d;
                        double d6 = 0.0;
                        for (n6 = 0; n6 <= i; ++n6) {
                            d6 += dArray2[i][n6] * dArray2[n2][n6];
                        }
                        for (n6 = i + 1; n6 <= n; ++n6) {
                            d6 += dArray2[n6][i] * dArray2[n2][n6];
                        }
                        dArray4[i] = d6 / d;
                        d5 += dArray4[i] * dArray2[n2][i];
                    }
                    double d7 = d5 / (d + d);
                    for (int i = 0; i <= n; ++i) {
                        double d8 = dArray2[n2][i];
                        int n7 = i;
                        double d9 = dArray4[n7] - d7 * d8;
                        dArray4[n7] = d9;
                        double d10 = d9;
                        for (int j = 0; j <= i; ++j) {
                            double[] dArray6 = dArray2[i];
                            int n8 = j;
                            dArray6[n8] = dArray6[n8] - (d8 * dArray4[j] + d10 * dArray2[n2][j]);
                        }
                    }
                }
            } else {
                dArray4[n2] = dArray2[n2][n];
            }
            dArray3[n2] = d;
        }
        dArray3[1] = 0.0;
        dArray4[1] = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            int n9;
            n = n2 - 1;
            if (dArray3[n2] != 0.0) {
                for (n9 = 0; n9 <= n; ++n9) {
                    int n10;
                    double d = 0.0;
                    for (n10 = 0; n10 <= n; ++n10) {
                        d += dArray2[n2][n10] * dArray2[n10][n9];
                    }
                    for (n10 = 0; n10 <= n; ++n10) {
                        double[] dArray7 = dArray2[n10];
                        int n11 = n9;
                        dArray7[n11] = dArray7[n11] - d * dArray2[n10][n2];
                    }
                }
            }
            dArray3[n2] = dArray2[n2][n2];
            dArray2[n2][n2] = 1.0;
            for (n9 = 0; n9 <= n; ++n9) {
                dArray2[n2][n9] = 0.0;
                dArray2[n9][n2] = 0.0;
            }
        }
    }

    public static void transform(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n;
        double[] dArray4 = dArray3[0];
        double[] dArray5 = dArray3[1];
        Tridiagonal.transform(dArray, dArray2, dArray4, dArray5);
        int n2 = dArray.length;
        dArray3[1][0] = dArray5[1];
        dArray3[1][1] = dArray4[1];
        dArray3[0][1] = dArray3[1][0];
        for (n = 2; n < n2; ++n) {
            dArray3[n][n] = dArray4[n];
            double d = dArray5[n];
            dArray3[n - 1][n] = d;
            dArray3[n][n - 1] = d;
        }
        for (n = 0; n < n2; ++n) {
            int n3;
            for (n3 = 0; n3 < n - 1; ++n3) {
                dArray3[n][n3] = 0.0;
            }
            for (n3 = n + 2; n3 < n2; ++n3) {
                dArray3[n][n3] = 0.0;
            }
        }
    }
}

