/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.Location;

public class ArrowedFeatureRenderer
implements FeatureRenderer {
    private Paint fill = Color.red;
    private Paint outline = Color.black;
    private double arrowSize = 15.0;
    private double arrowScoop = 4.0;
    private double arrowHeadWidth = 5.0;

    public void setFill(Paint p) {
        this.fill = p;
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setOutline(Paint p) {
        this.outline = p;
    }

    public Paint getOutline() {
        return this.outline;
    }

    public void setArrowSize(double arrowSize) {
        this.arrowSize = arrowSize;
    }

    public double getArrowSize() {
        return this.arrowSize;
    }

    public void setArrowScoop(double arrowScoop) {
        this.arrowScoop = arrowScoop;
    }

    public double getArrowScoop() {
        return this.arrowScoop;
    }

    public void setArrowHeadSize(double d) {
        this.arrowHeadWidth = d;
    }

    public double getArrowHeadSize() {
        return this.arrowHeadWidth;
    }

    public void renderFeature(Graphics2D g, Feature f, SequenceRenderContext src) {
        double maxD;
        double minD;
        Shape s = null;
        Location loc = f.getLocation();
        float depth = (float)(this.arrowSize + 2.0 * this.arrowScoop);
        if (src.getScale() > 1.0) {
            minD = src.sequenceToGraphics(loc.getMin());
            maxD = src.sequenceToGraphics(loc.getMax() + 1) - 1.0;
        } else {
            minD = src.sequenceToGraphics(loc.getMin());
            maxD = src.sequenceToGraphics(loc.getMax());
        }
        float min = (float)minD;
        float max = (float)maxD;
        float minBounds = (float)src.sequenceToGraphics(src.getRange().getMin() - 1);
        float maxBounds = (float)src.sequenceToGraphics(src.getRange().getMax() + 1);
        Rectangle2D.Double bounds = src.getDirection() == 0 ? new Rectangle2D.Double(minBounds, 0.0, maxBounds - minBounds, depth) : new Rectangle2D.Double(0.0, minBounds, depth, maxBounds - minBounds);
        if ((double)(max - min) >= this.arrowSize && src.getDirection() == 0) {
            float minY = 0.0f;
            float maxY = depth;
            float minYS = minY + (float)this.arrowScoop;
            float maxYS = maxY - (float)this.arrowScoop;
            float midY = (minY + maxY) * 0.5f;
            float minX = min;
            float maxX = max;
            float midX1 = maxX - (float)this.getArrowHeadSize();
            float midX2 = minX + (float)this.getArrowHeadSize();
            GeneralPath path = new GeneralPath();
            path.moveTo(minX, midY);
            path.lineTo(midX2, minY);
            path.lineTo(midX2, minYS);
            path.lineTo(midX1, minYS);
            path.lineTo(midX1, minY);
            path.lineTo(maxX, midY);
            path.lineTo(midX1, maxY);
            path.lineTo(midX1, maxYS);
            path.lineTo(midX2, maxYS);
            path.lineTo(midX2, maxY);
            path.closePath();
            s = path;
        }
        if (!bounds.contains(s.getBounds())) {
            s = new Area(s);
            ((Area)s).intersect(new Area(bounds));
        }
        if (this.fill != null) {
            g.setPaint(this.fill);
            g.fill(s);
        }
        if (this.outline != null && maxD - minD > 4.0) {
            g.setPaint(this.outline);
            g.draw(s);
        }
    }

    public double getDepth(SequenceRenderContext src) {
        return this.arrowSize + 2.0 * this.arrowScoop + 1.0;
    }

    public FeatureHolder processMouseEvent(FeatureHolder hits, SequenceRenderContext src, MouseEvent me) {
        return hits;
    }
}

