/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.gui.sequence.PairwiseRenderContext;
import org.biojava.bio.gui.sequence.PairwiseSequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.gui.sequence.SubPairwiseRenderContext;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;
import org.biojava.utils.cache.CacheMap;
import org.biojava.utils.cache.FixedSizeMap;

public class PairwiseFilteringRenderer
extends AbstractChangeable
implements PairwiseSequenceRenderer,
Serializable {
    public static final ChangeType FILTER = new ChangeType("The filter has changed", "org.biojava.bio.gui.sequence.PairwiseFilteringRenderer", "FILTER", SequenceRenderContext.LAYOUT);
    public static final ChangeType RECURSE = new ChangeType("The recurse flag has changed", "org.biojava.bio.gui.sequence.PairwiseFilteringRenderer", "RECURSE", SequenceRenderContext.LAYOUT);
    public static final ChangeType RENDERER = new ChangeType("The renderer has changed", "org.biojava.bio.gui.sequence.PairwiseFilteringRenderer", "RENDERER", SequenceRenderContext.REPAINT);
    protected FeatureFilter filter;
    protected boolean recurse;
    private CacheMap subContextCache = new FixedSizeMap(5);
    private Set cacheFlushers = new HashSet();
    private PairwiseSequenceRenderer renderer;
    private transient ChangeForwarder rendererForwarder;

    public PairwiseFilteringRenderer(PairwiseSequenceRenderer renderer) {
        this(renderer, FeatureFilter.all, false);
    }

    public PairwiseFilteringRenderer(PairwiseSequenceRenderer renderer, FeatureFilter filter, boolean recurse) {
        try {
            this.renderer = renderer;
            this.setFilter(filter);
            this.setRecurse(recurse);
        }
        catch (ChangeVetoException cve) {
            throw new BioError("Assertion failed: should have no listeners", cve);
        }
    }

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport cs = super.getChangeSupport(ct);
        if (this.rendererForwarder == null) {
            this.rendererForwarder = new PairwiseSequenceRenderer.PairwiseRendererForwarder(this, cs);
            if (this.renderer instanceof Changeable) {
                Changeable c = (Changeable)((Object)this.renderer);
                c.addChangeListener(this.rendererForwarder, SequenceRenderContext.REPAINT);
            }
        }
        return cs;
    }

    public PairwiseSequenceRenderer getRenderer() {
        return this.renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderer(PairwiseSequenceRenderer renderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RENDERER, renderer, this.renderer);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RENDERER);
            synchronized (changeSupport) {
                Changeable c;
                cs.firePreChangeEvent(ce);
                if (this.renderer instanceof Changeable) {
                    c = (Changeable)((Object)this.renderer);
                    c.removeChangeListener(this.rendererForwarder);
                }
                this.renderer = renderer;
                if (renderer instanceof Changeable) {
                    c = (Changeable)((Object)renderer);
                    c.addChangeListener(this.rendererForwarder);
                }
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.renderer = renderer;
        }
    }

    public FeatureFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(FeatureFilter filter) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(FILTER);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, FILTER, this.filter, filter);
                cs.firePreChangeEvent(ce);
                this.filter = filter;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.filter = filter;
        }
    }

    public boolean getRecurse() {
        return this.recurse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecurse(boolean recurse) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(RECURSE);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, RECURSE, new Boolean(recurse), new Boolean(this.recurse));
                cs.firePreChangeEvent(ce);
                this.recurse = recurse;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.recurse = recurse;
        }
    }

    public void paint(Graphics2D g2, PairwiseRenderContext context) {
        this.renderer.paint(g2, this.getSubContext(context));
    }

    public SequenceViewerEvent processMouseEvent(PairwiseRenderContext context, MouseEvent me, List path) {
        path.add(this);
        return this.renderer.processMouseEvent(this.getSubContext(context), me, path);
    }

    protected PairwiseRenderContext getSubContext(PairwiseRenderContext context) {
        FeatureFilter.And ffSec;
        FeatureFilter.And ff = new FeatureFilter.And(this.filter, new FeatureFilter.OverlapsLocation(context.getRange()));
        FilteredSubContext cacheKey = new FilteredSubContext(context, ff, ffSec = new FeatureFilter.And(this.filter, new FeatureFilter.OverlapsLocation(context.getSecondaryRange())), this.recurse);
        PairwiseRenderContext filtered = (PairwiseRenderContext)this.subContextCache.get(cacheKey);
        if (filtered == null) {
            filtered = new SubPairwiseRenderContext(context, null, null, context.getFeatures().filter(ff, this.recurse), context.getFeatures().filter(ffSec, this.recurse), null, null);
            this.subContextCache.put(cacheKey, filtered);
            CacheFlusher cf = new CacheFlusher(cacheKey);
            context.getSymbols().addChangeListener(cf, FeatureHolder.FEATURES);
            this.cacheFlushers.add(cf);
        }
        return filtered;
    }

    private class CacheFlusher
    implements ChangeListener {
        private FilteredSubContext fsc;

        public CacheFlusher(FilteredSubContext fsc) {
            this.fsc = fsc;
        }

        public void preChange(ChangeEvent ce) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postChange(ChangeEvent ce) {
            PairwiseFilteringRenderer.this.subContextCache.remove(this.fsc);
            PairwiseFilteringRenderer.this.cacheFlushers.remove(this);
            if (PairwiseFilteringRenderer.this.hasListeners()) {
                ChangeSupport cs;
                ChangeSupport changeSupport = cs = PairwiseFilteringRenderer.this.getChangeSupport(SequenceRenderContext.LAYOUT);
                synchronized (changeSupport) {
                    ChangeEvent ce2 = new ChangeEvent(PairwiseFilteringRenderer.this, SequenceRenderContext.LAYOUT);
                    cs.firePostChangeEvent(ce2);
                }
            }
        }
    }

    private class FilteredSubContext {
        private PairwiseRenderContext context;
        private FeatureFilter filter;
        private FeatureFilter secondaryFilter;
        private boolean recurse;

        public FilteredSubContext(PairwiseRenderContext context, FeatureFilter filter, FeatureFilter secondaryFilter, boolean recurse) {
            this.context = context;
            this.filter = filter;
            this.secondaryFilter = secondaryFilter;
            this.recurse = recurse;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FilteredSubContext)) {
                return false;
            }
            FilteredSubContext that = (FilteredSubContext)o;
            return this.context.equals(that.context) && this.filter.equals(that.filter) && this.secondaryFilter.equals(that.secondaryFilter) && this.recurse == that.recurse;
        }

        public int hashCode() {
            return this.context.hashCode() ^ this.filter.hashCode();
        }
    }
}

