/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DASDistDataSource;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.program.das.DataSource;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.distributed.DistDataSource;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class ReferenceServer
extends DataSource
implements Changeable {
    public static final ChangeType ANNOTATOR = new ChangeType("Annotator added", ReferenceServer.class, "ANNOTATOR");
    private Set annotators = new HashSet();
    private Set publicAnnotators = Collections.unmodifiableSet(this.annotators);
    private transient ChangeSupport changeSupport = null;

    protected boolean hasListeners() {
        return this.changeSupport != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChangeSupport getChangeSupport(ChangeType ct) {
        if (this.changeSupport != null) {
            return this.changeSupport;
        }
        ReferenceServer referenceServer = this;
        synchronized (referenceServer) {
            if (this.changeSupport == null) {
                this.changeSupport = new ChangeSupport();
            }
        }
        return this.changeSupport;
    }

    public final void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public final void addChangeListener(ChangeListener cl, ChangeType ct) {
        ChangeSupport cs = this.getChangeSupport(ct);
        cs.addChangeListener(cl, ct);
    }

    public final void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public final void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(ct);
            cs.removeChangeListener(cl, ct);
        }
    }

    public final boolean isUnchanging(ChangeType ct) {
        ChangeSupport cs = this.getChangeSupport(ct);
        return cs.isUnchanging(ct);
    }

    ReferenceServer(URL dasURL, String name, String description) {
        super(dasURL, dasURL, name, description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAnnotator(DataSource ann) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(ANNOTATOR);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, ANNOTATOR);
                cs.firePreChangeEvent(ce);
                this.annotators.add(ann);
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.annotators.add(ann);
        }
    }

    public Set getAnnotaters() {
        return this.publicAnnotators;
    }

    public SequenceDB getDB() throws BioException {
        return new DASSequenceDB(this.getURL());
    }

    public DistDataSource getDistDataSource() throws BioException {
        return new DASDistDataSource(this.getURL());
    }
}

