/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssbind;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.program.ssbind.AlphabetResolver;
import org.biojava.bio.program.ssbind.AnnotationFactory;
import org.biojava.bio.search.SearchBuilder;
import org.biojava.bio.search.SeqSimilaritySearchHit;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.search.SeqSimilaritySearchSubHit;
import org.biojava.bio.search.SimpleSeqSimilaritySearchHit;
import org.biojava.bio.search.SimpleSeqSimilaritySearchResult;
import org.biojava.bio.search.SimpleSeqSimilaritySearchSubHit;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBInstallation;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.utils.SmallMap;

public class BlastLikeSearchBuilder
implements SearchBuilder {
    private SequenceDBInstallation subjectDBs;
    private SequenceDB querySeqHolder;
    private String databaseID;
    private String queryID;
    private Annotation resultAnnotation;
    private Map resultPreAnnotation;
    private Map searchParameters;
    private Map hitData;
    private Map subHitData;
    private SymbolTokenization tokenParser;
    private List hits;
    private List subHits;
    private SeqSimilaritySearchSubHit[] subs;
    private boolean moreSearchesAvailable = false;
    private List target;

    public BlastLikeSearchBuilder(List target) {
        this.target = target;
        this.resultPreAnnotation = new HashMap();
        this.searchParameters = new HashMap();
        this.hitData = new HashMap();
        this.subHitData = new HashMap();
    }

    public BlastLikeSearchBuilder(List target, SequenceDB querySeqHolder, SequenceDBInstallation subjectDBs) {
        this(target);
        this.querySeqHolder = querySeqHolder;
        this.subjectDBs = subjectDBs;
    }

    public SeqSimilaritySearchResult makeSearchResult() throws BioException {
        if (this.querySeqHolder == null) {
            throw new BioException("Running BlastLikeSearchBuilder with null query SequenceDB");
        }
        if (this.subjectDBs == null) {
            throw new BioException("Running BlastLikeSearchBuilder with null subject SequenceDB installation");
        }
        Sequence query = this.querySeqHolder.getSequence(this.queryID);
        if (query == null) {
            throw new BioException("Failed to retrieve query sequence from queryDB using ID '" + this.queryID + "' (sequence was null)");
        }
        SequenceDB subjectDB = (SequenceDB)this.subjectDBs.getSequenceDB(this.databaseID);
        if (subjectDB == null) {
            throw new BioException("Failed to retrieve database from installation using ID '" + this.databaseID + "' (database was null)");
        }
        return new SimpleSeqSimilaritySearchResult(query, subjectDB, this.searchParameters, this.hits, this.resultAnnotation);
    }

    public void setQuerySeqHolder(SequenceDB querySeqHolder) {
        this.querySeqHolder = querySeqHolder;
    }

    public void setSubjectDBInstallation(SequenceDBInstallation subjectDBs) {
        this.subjectDBs = subjectDBs;
    }

    public void setQueryID(String queryID) {
        this.queryID = queryID;
        this.addSearchProperty("queryId", queryID);
    }

    public void setDatabaseID(String databaseID) {
        this.databaseID = databaseID;
        this.addSearchProperty("databaseId", databaseID);
    }

    public boolean getMoreSearches() {
        return this.moreSearchesAvailable;
    }

    public void setMoreSearches(boolean value) {
        this.moreSearchesAvailable = value;
    }

    public void startSearch() {
        this.hits = new ArrayList();
    }

    public void endSearch() {
        try {
            this.resultAnnotation = AnnotationFactory.makeAnnotation(this.resultPreAnnotation);
            this.target.add(this.makeSearchResult());
        }
        catch (BioException be) {
            System.err.println("Failed to build SeqSimilaritySearchResult:");
            be.printStackTrace();
        }
    }

    public void startHeader() {
        this.resultPreAnnotation.clear();
        this.searchParameters.clear();
    }

    public void endHeader() {
    }

    public void startHit() {
        this.hitData.clear();
        this.subHits = new ArrayList();
    }

    public void endHit() {
        this.hits.add(this.makeHit());
    }

    public void startSubHit() {
        this.subHitData.clear();
    }

    public void endSubHit() {
        try {
            this.subHits.add(this.makeSubHit());
        }
        catch (BioException be) {
            be.printStackTrace();
        }
    }

    public void addSearchProperty(Object key, Object value) {
        this.resultPreAnnotation.put(key, value);
    }

    public void addHitProperty(Object key, Object value) {
        this.hitData.put(key, value);
    }

    public void addSubHitProperty(Object key, Object value) {
        this.subHitData.put(key, value);
    }

    private SeqSimilaritySearchHit makeHit() {
        double sc = Double.NaN;
        double ev = Double.NaN;
        double pv = Double.NaN;
        this.subs = this.subHits.toArray(new SeqSimilaritySearchSubHit[this.subHits.size() - 1]);
        Arrays.sort(this.subs, SeqSimilaritySearchSubHit.byScore);
        sc = this.subs[this.subs.length - 1].getScore();
        ev = this.subs[this.subs.length - 1].getEValue();
        pv = this.subs[this.subs.length - 1].getPValue();
        boolean mixQueryStrand = false;
        boolean mixSubjectStrand = false;
        boolean nullQueryStrand = false;
        boolean nullSubjectStrand = false;
        StrandedFeature.Strand qStrand = this.subs[0].getQueryStrand();
        StrandedFeature.Strand sStrand = this.subs[0].getSubjectStrand();
        int qStart = this.subs[0].getQueryStart();
        int qEnd = this.subs[0].getQueryEnd();
        int sStart = this.subs[0].getSubjectStart();
        int sEnd = this.subs[0].getSubjectEnd();
        if (qStrand == null) {
            nullQueryStrand = true;
        }
        if (sStrand == null) {
            nullSubjectStrand = true;
        }
        int i = this.subs.length;
        while (--i > 0) {
            StrandedFeature.Strand qS = this.subs[i].getQueryStrand();
            StrandedFeature.Strand sS = this.subs[i].getSubjectStrand();
            if (qS == null) {
                nullQueryStrand = true;
            }
            if (sS == null) {
                nullSubjectStrand = true;
            }
            if (qS != qStrand) {
                mixQueryStrand = true;
            }
            if (sS != sStrand) {
                mixSubjectStrand = true;
            }
            qStart = Math.min(qStart, this.subs[i].getQueryStart());
            qEnd = Math.max(qEnd, this.subs[i].getQueryEnd());
            sStart = Math.min(sStart, this.subs[i].getSubjectStart());
            sEnd = Math.max(sEnd, this.subs[i].getSubjectEnd());
        }
        if (mixQueryStrand) {
            qStrand = StrandedFeature.UNKNOWN;
        }
        if (mixSubjectStrand) {
            sStrand = StrandedFeature.UNKNOWN;
        }
        if (nullQueryStrand) {
            qStrand = null;
        }
        if (nullSubjectStrand) {
            sStrand = null;
        }
        String subjectID = (String)this.hitData.get("subjectId");
        return new SimpleSeqSimilaritySearchHit(sc, ev, pv, qStart, qEnd, qStrand, sStart, sEnd, sStrand, subjectID, AnnotationFactory.makeAnnotation(this.hitData), this.subHits);
    }

    private SeqSimilaritySearchSubHit makeSubHit() throws BioException {
        int swap;
        if (this.tokenParser == null) {
            String identifier;
            if (this.subHitData.containsKey("subjectSequenceType")) {
                identifier = (String)this.subHitData.get("subjectSequenceType");
            } else if (this.resultPreAnnotation.containsKey("program")) {
                identifier = (String)this.resultPreAnnotation.get("program");
            } else {
                throw new BioException("Failed to determine sequence type");
            }
            FiniteAlphabet alpha = AlphabetResolver.resolveAlphabet(identifier);
            this.tokenParser = alpha.getTokenization("token");
        }
        StrandedFeature.Strand qStrand = null;
        StrandedFeature.Strand sStrand = null;
        if (this.subHitData.containsKey("queryStrand")) {
            qStrand = this.subHitData.get("queryStrand").equals("plus") ? StrandedFeature.POSITIVE : StrandedFeature.NEGATIVE;
        }
        if (this.subHitData.containsKey("subjectStrand")) {
            sStrand = this.subHitData.get("subjectStrand").equals("plus") ? StrandedFeature.POSITIVE : StrandedFeature.NEGATIVE;
        }
        if (this.subHitData.containsKey("queryFrame")) {
            qStrand = ((String)this.subHitData.get("queryFrame")).startsWith("plus") ? StrandedFeature.POSITIVE : StrandedFeature.NEGATIVE;
        }
        if (this.subHitData.containsKey("subjectFrame")) {
            sStrand = ((String)this.subHitData.get("subjectFrame")).startsWith("plus") ? StrandedFeature.POSITIVE : StrandedFeature.NEGATIVE;
        }
        int qStart = Integer.parseInt((String)this.subHitData.get("querySequenceStart"));
        int qEnd = Integer.parseInt((String)this.subHitData.get("querySequenceEnd"));
        int sStart = Integer.parseInt((String)this.subHitData.get("subjectSequenceStart"));
        int sEnd = Integer.parseInt((String)this.subHitData.get("subjectSequenceEnd"));
        if (qStrand == StrandedFeature.NEGATIVE) {
            swap = qStart;
            qStart = qEnd;
            qEnd = swap;
        }
        if (sStrand == StrandedFeature.NEGATIVE) {
            swap = sStart;
            sStart = sEnd;
            sEnd = swap;
        }
        double sc = Double.NaN;
        double ev = Double.NaN;
        double pv = Double.NaN;
        if (this.subHitData.containsKey("score")) {
            sc = Double.parseDouble((String)this.subHitData.get("score"));
        }
        if (this.subHitData.containsKey("expectValue")) {
            String val = (String)this.subHitData.get("expectValue");
            ev = val.startsWith("e") ? Double.parseDouble("1" + val) : Double.parseDouble(val);
        }
        if (this.subHitData.containsKey("pValue")) {
            pv = Double.parseDouble((String)this.subHitData.get("pValue"));
        }
        SmallMap labelMap = new SmallMap();
        StringBuffer tokenBuffer = new StringBuffer(1024);
        tokenBuffer.append((String)this.subHitData.remove("querySequence"));
        labelMap.put("Query", new SimpleSymbolList(this.tokenParser, tokenBuffer.substring(0)));
        tokenBuffer = new StringBuffer(1024);
        tokenBuffer.append((String)this.subHitData.remove("subjectSequence"));
        labelMap.put(this.hitData.get("subjectId"), new SimpleSymbolList(this.tokenParser, tokenBuffer.substring(0)));
        return new SimpleSeqSimilaritySearchSubHit(sc, ev, pv, qStart, qEnd, qStrand, sStart, sEnd, sStrand, new SimpleAlignment(labelMap), AnnotationFactory.makeAnnotation(this.subHitData));
    }
}

