/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.SmallMap;

public class FeatureTypes {
    private static final Map repositories = new SmallMap();
    public static final String URI_PREFIX = "uri:biojava.org:types";

    public static Repository getRepository(String name) throws NoSuchElementException {
        Repository rep = (Repository)((Object)repositories);
        if (rep == null) {
            throw new NoSuchElementException("Could not find repository: " + name);
        }
        return rep;
    }

    public static Set getRepositoryNames() {
        return repositories.keySet();
    }

    public static void addRepository(Repository repos) {
        repositories.put(repos.getName(), repos);
    }

    public static void removeRepository(Repository repos) {
        repositories.remove(repos.getName());
    }

    public static Type getType(String uri) {
        if (!uri.startsWith(URI_PREFIX)) {
            throw new NoSuchElementException("All types start with: uri:biojava.org:types while processing " + uri);
        }
        String names = uri.substring(URI_PREFIX.length() + 1);
        int slash = uri.indexOf("/");
        String repName = names.substring(0, slash);
        String typeName = names.substring(slash + 1);
        Repository rep = FeatureTypes.getRepository(repName);
        return rep.getType(typeName);
    }

    public static boolean isSubTypeOf(Type subType, Type superType) {
        Set parents = subType.getParents();
        if (parents.contains(superType.getURI())) {
            return true;
        }
        Iterator i = parents.iterator();
        if (i.hasNext()) {
            String puri = (String)i.next();
            return FeatureTypes.isSubTypeOf(FeatureTypes.getType(puri), superType);
        }
        return false;
    }

    public static class RepositoryImpl
    extends AbstractChangeable
    implements Repository {
        private final String name;
        private final Map types;
        private final Annotation ann;

        public RepositoryImpl(String name) {
            this.name = name;
            this.types = new HashMap();
            this.ann = new SimpleAnnotation();
        }

        protected ChangeSupport getChangeSupport(ChangeType ct) {
            ChangeSupport cs = super.getChangeSupport(ct);
            this.ann.addChangeListener(new Annotatable.AnnotationForwarder(this, cs), Annotation.PROPERTY);
            return cs;
        }

        public Annotation getAnnotation() {
            return this.ann;
        }

        public String getName() {
            return this.name;
        }

        public Set getTypes() {
            return this.types.keySet();
        }

        public Type getType(String name) throws NoSuchElementException {
            Type type = (Type)this.types.get(name);
            if (type == null) {
                throw new NoSuchElementException("Could not find type " + name + " in repository " + this.getName());
            }
            return type;
        }

        public Type createType(String name, FeatureFilter schema, Set parents) {
            TypeImpl type = new TypeImpl(name, schema, parents);
            this.types.put(name, type);
            return type;
        }

        private class TypeImpl
        extends AbstractChangeable
        implements Type {
            private Annotation ann;
            private String name;
            private FeatureFilter schema;
            private Set parents;

            public TypeImpl(String name, FeatureFilter schema, Set parents) {
                this.name = name;
                this.schema = schema;
                this.parents = parents;
                this.ann = new SimpleAnnotation();
            }

            protected ChangeSupport getChangeSupport(ChangeType ct) {
                ChangeSupport cs = super.getChangeSupport(ct);
                this.ann.addChangeListener(new Annotatable.AnnotationForwarder(this, cs), Annotation.PROPERTY);
                return cs;
            }

            public Annotation getAnnotation() {
                return this.ann;
            }

            public String getName() {
                return this.name;
            }

            public FeatureFilter getSchema() {
                return this.schema;
            }

            public Set getParents() {
                return this.parents;
            }

            public String getURI() {
                return "uri:biojava.org:types/" + RepositoryImpl.this.getName() + "/" + this.name;
            }
        }
    }

    public static interface Type
    extends Annotatable {
        public FeatureFilter getSchema();

        public String getName();

        public Set getParents();

        public String getURI();
    }

    public static interface Repository
    extends Annotatable {
        public String getName();

        public Set getTypes();

        public Type getType(String var1) throws NoSuchElementException;
    }
}

