/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeHub;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class IndexedChangeHub
implements ChangeHub {
    private ReferenceQueue refQueue = new ReferenceQueue();
    private Map listeners = new HashMap();

    protected abstract boolean isMyChangeEvent(ChangeEvent var1, ListenerMemento var2);

    public void addListener(Object key, ChangeListener listener, ChangeType ct) {
        this.diddleQueue();
        ArrayList<ListenerMemento> listenerList = (ArrayList<ListenerMemento>)this.listeners.get(key);
        if (listenerList == null) {
            listenerList = new ArrayList<ListenerMemento>();
            this.listeners.put(key, listenerList);
        }
        listenerList.add(new ListenerMemento(ct, new ListenerReference(key, listener, this.refQueue)));
    }

    public void removeListener(Object key, ChangeListener listener, ChangeType ct) {
        List listenerList = (List)this.listeners.get(key);
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ListenerMemento lm = (ListenerMemento)i.next();
                if (ct != lm.type || !listener.equals(lm.listener.get())) continue;
                lm.listener.clear();
                i.remove();
                return;
            }
        }
    }

    public void firePreChange(Object key, ChangeEvent cev) throws ChangeVetoException {
        List listenerList = (List)this.listeners.get(key);
        if (listenerList != null) {
            for (ListenerMemento lm : listenerList) {
                ChangeListener cl;
                if (!this.isMyChangeEvent(cev, lm) || (cl = (ChangeListener)lm.listener.get()) == null) continue;
                cl.preChange(cev);
            }
        }
    }

    public void firePostChange(Object key, ChangeEvent cev) {
        List listenerList = (List)this.listeners.get(key);
        if (listenerList != null) {
            for (ListenerMemento lm : listenerList) {
                ChangeListener cl;
                if (!this.isMyChangeEvent(cev, lm) || (cl = (ChangeListener)lm.listener.get()) == null) continue;
                cl.postChange(cev);
            }
        }
    }

    protected void diddleQueue() {
        Reference ref;
        block0: while ((ref = this.refQueue.poll()) != null) {
            List listenerList = (List)this.listeners.get(((ListenerReference)ref).getKey());
            if (listenerList == null) continue;
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ListenerMemento lm = (ListenerMemento)i.next();
                if (lm.listener != ref) continue;
                i.remove();
                continue block0;
            }
        }
    }

    protected class ListenerMemento {
        public final ChangeType type;
        public final Reference listener;

        public ListenerMemento(ChangeType type, Reference listener) {
            this.type = type;
            this.listener = listener;
        }
    }

    private class ListenerReference
    extends WeakReference {
        private Object key;

        public ListenerReference(Object key, Object ref) {
            super(ref);
            this.key = key;
        }

        public ListenerReference(Object key, Object ref, ReferenceQueue queue) {
            super(ref, queue);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }
}

