/*
 * Decompiled with CFR 0.152.
 */
package projects.crispr;

import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.util.Arrays;
import projects.crispr.PositionPrior;

public class BinomialPositionPrior
implements PositionPrior {
    private double[] pars;
    private double[] logP;

    public BinomialPositionPrior(int length) {
        this.pars = new double[length];
        this.logP = new double[length];
    }

    @Override
    public BinomialPositionPrior clone() throws CloneNotSupportedException {
        BinomialPositionPrior clone = (BinomialPositionPrior)super.clone();
        clone.pars = (double[])this.pars.clone();
        clone.logP = (double[])this.logP.clone();
        return clone;
    }

    @Override
    public double getLogScore(int position) {
        return this.logP[position];
    }

    @Override
    public double getLogScoreAndPartialDerivation(int position, IntList indices, DoubleList partialDer) {
        indices.add(position);
        partialDer.add(-Math.exp(this.logP[position]) * Math.exp(this.pars[position]));
        return this.logP[position];
    }

    @Override
    public int getNumberOfParameters() {
        return this.pars.length;
    }

    @Override
    public void setParameters(double[] pars, int off) {
        System.arraycopy(pars, off, this.pars, 0, this.pars.length);
        int i = 0;
        while (i < this.pars.length) {
            this.logP[i] = -Math.log1p(Math.exp(this.pars[i]));
            ++i;
        }
    }

    @Override
    public double[] getCurrentParameterValues() {
        return (double[])this.pars.clone();
    }

    @Override
    public double getLogPriorTerm() {
        return 0.0;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int off) {
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) {
        int i = 0;
        while (i < this.pars.length) {
            this.pars[i] = 4.0 * Math.random() - 2.0;
            this.logP[i] = -Math.log1p(Math.exp(this.pars[i]));
            ++i;
        }
    }

    public String toString() {
        return Arrays.toString(this.logP);
    }
}

