/*
 * Decompiled with CFR 0.152.
 */
package projects.crispr;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.MarkovModelDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.InhomogeneousMarkov;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.text.NumberFormat;

public class ConditionalIMM
extends AbstractDifferentiableStatisticalModel {
    private MarkovModelDiffSM[] models = new MarkovModelDiffSM[4];
    private int[][] parameterMap;
    private int[] offsets;
    private double ess;

    public ConditionalIMM(int length, double ess) throws SimpleParameter.IllegalValueException, CloneNotSupportedException, Exception {
        super(DNAAlphabetContainer.SINGLETON, length);
        int i = 0;
        while (i < this.models.length) {
            this.models[i] = new MarkovModelDiffSM((AlphabetContainer)DNAAlphabetContainer.SINGLETON, length, ess / 4.0, true, new InhomogeneousMarkov(0));
            ++i;
        }
        this.ess = ess;
    }

    @Override
    public ConditionalIMM clone() throws CloneNotSupportedException {
        ConditionalIMM clone = (ConditionalIMM)super.clone();
        clone.models = (MarkovModelDiffSM[])ArrayHandler.clone((Cloneable[])this.models);
        if (this.parameterMap != null) {
            clone.parameterMap = (int[][])ArrayHandler.clone((Cloneable[])this.parameterMap);
        }
        if (this.offsets != null) {
            clone.offsets = (int[])this.offsets.clone();
        }
        return clone;
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    @Override
    public double getLogNormalizationConstant() {
        double ln = 0.0;
        int i = 0;
        while (i < this.models.length) {
            ln += this.models[i].getLogNormalizationConstant();
            ++i;
        }
        return ln;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return this.models[this.parameterMap[parameterIndex][0]].getLogPartialNormalizationConstant(this.parameterMap[parameterIndex][0]);
    }

    @Override
    public double getLogPriorTerm() {
        double lp = 0.0;
        int i = 0;
        while (i < this.models.length) {
            lp += this.models[i].getLogPriorTerm();
            ++i;
        }
        return lp;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        int i = 0;
        while (i < this.models.length) {
            this.models[i].addGradientOfLogPriorTerm(grad, start);
            start += this.models[i].getNumberOfParameters();
            ++i;
        }
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        this.initializeFunctionRandomly(freeParams);
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        this.offsets = new int[this.models.length];
        int i = 0;
        while (i < this.models.length) {
            if (i > 0) {
                this.offsets[i] = this.offsets[i - 1] + this.models[i - 1].getNumberOfParameters();
            }
            this.models[i].initializeFunctionRandomly(freeParams);
            ++i;
        }
        this.parameterMap = new int[this.getNumberOfParameters()][2];
        i = 0;
        int k = 0;
        while (i < this.models.length) {
            int j = 0;
            while (j < this.models[i].getNumberOfParameters()) {
                this.parameterMap[k][0] = i;
                this.parameterMap[k][1] = j++;
                ++k;
            }
            ++i;
        }
    }

    private int getGRNASymbol(Sequence seq, int position) {
        Sequence grna = ((ReferenceSequenceAnnotation)seq.getSequenceAnnotationByType("reference", 0)).getReferenceSequence();
        return grna.discreteVal(position);
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, int end, IntList indices, DoubleList partialDer) throws WrongLengthException {
        double ls = 0.0;
        IntList temp = new IntList();
        int i = start;
        while (i <= end) {
            temp.clear();
            int grna = this.getGRNASymbol(seq, i);
            ls += this.models[grna].getPartialLogScoreAndPartialDerivation(seq, i - start, temp, partialDer);
            int j = 0;
            while (j < temp.length()) {
                indices.add(temp.get(j) + this.offsets[grna]);
                ++j;
            }
            ++i;
        }
        return ls;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        try {
            return this.getLogScoreAndPartialDerivation(seq, start, start + this.length - 1, indices, partialDer);
        }
        catch (WrongLengthException doesnothappen) {
            throw new RuntimeException();
        }
    }

    @Override
    public int getNumberOfParameters() {
        if (this.offsets == null) {
            return -1;
        }
        return this.offsets[this.offsets.length - 1] + this.models[this.offsets.length - 1].getNumberOfParameters();
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        double[] params = new double[this.getNumberOfParameters()];
        int off = 0;
        int i = 0;
        while (i < this.models.length) {
            double[] temp = this.models[i].getCurrentParameterValues();
            System.arraycopy(temp, 0, params, off, temp.length);
            off += temp.length;
            ++i;
        }
        return params;
    }

    @Override
    public void setParameters(double[] params, int start) {
        int i = 0;
        while (i < this.models.length) {
            this.models[i].setParameters(params, start);
            start += this.models[i].getNumberOfParameters();
            ++i;
        }
    }

    @Override
    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        try {
            return this.getLogScoreFor(seq, start, start + this.length - 1);
        }
        catch (WrongLengthException doesnothappen) {
            System.out.println(seq + " " + start + " " + this.length + " " + (start + this.length - 1));
            System.out.flush();
            doesnothappen.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        return 40;
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start, int end) throws WrongLengthException {
        double ls = 0.0;
        int i = start;
        while (i <= end) {
            int grna = this.getGRNASymbol(seq, i);
            ls += this.models[grna].getPartialLogScoreFor(seq, i - start);
            ++i;
        }
        return ls;
    }

    @Override
    public boolean isInitialized() {
        return this.models[0].isInitialized();
    }

    @Override
    public String toString(NumberFormat nf) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.models.length) {
            sb.append(String.valueOf(this.models[i].toString(nf)) + "\n");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public StringBuffer toXML() {
        return null;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
    }
}

