/*
 * Decompiled with CFR 0.152.
 */
package projects.tals;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Pair;
import de.jstacs.utils.galaxy.MultilineSimpleParameter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import projects.tals.TALgetterDiffSM;
import projects.tals.TBSScanner;

public class TBSScannerLong {
    public static TBSScanner.ResultList[] scan(TALgetterDiffSM model, TBSScannerLongParameterSet params, BufferedReader dsRead) throws Exception {
        if (!params.hasDefaultOrIsSet()) {
            System.err.println("Some of the required parameters are not specified.");
            System.exit(1);
        }
        String[] alph = new String[]{"NI", "NG", "NN", "NS", "N*", "ND", "NK", "NC", "NV", "NA", "NH", "HD", "HG", "HA", "H*", "HH", "HI", "HN", "S*", "SN", "SS", "IG", "YG", "NP", "NT", "IS"};
        AlphabetContainer alphabetsRVD = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, alph));
        Sequence tal = Sequence.create(alphabetsRVD, params.getTALSequence(), "-");
        TBSScanner.ResultList rl = new TBSScanner.ResultList(params.getN());
        TBSScanner.ResultList rl2 = new TBSScanner.ResultList(params.getN());
        StringBuffer lastHeader = new StringBuffer();
        Pair<int[][], Sequence[]> curr = null;
        while ((curr = TBSScannerLong.readNextSequences(dsRead, lastHeader)) != null) {
            int[][] offsets = curr.getFirstElement();
            Sequence[] seqs = curr.getSecondElement();
            int s = 0;
            while (s < seqs.length) {
                Sequence seq = seqs[s];
                String id = (String)seq.getSequenceAnnotationByType("unparsed comment line", 0).getResultForName("unparsed comment").getValue();
                id = id.trim();
                int j = 0;
                while (j < seq.getLength() - tal.getLength()) {
                    Sequence sub = seq.getSubSequence(j, tal.getLength() + 1);
                    sub = sub.annotate(true, seq.getAnnotation());
                    double score = model.getLogScoreFor(sub = sub.annotate(true, new ReferenceSequenceAnnotation("seq", tal, new Result[0])));
                    if (rl.better(score)) {
                        String str = model.getMatchString(sub);
                        Result[] tr = new Result[]{new CategoricalResult("ID", "", id), new NumericalResult("Position", "", j + offsets[0][s]), new NumericalResult("Distance to end", "", seq.getLength() - (j + tal.getLength() + 1) + offsets[1][s]), new CategoricalResult("Sequence", "", sub.toString()), new CategoricalResult("Matches", "", str), new NumericalResult("Score", "", score)};
                        rl.add(new ResultSet(new Result[][]{tr}), score);
                        tr[0] = new TBSScanner.GeneLinkResult("ID", "", id);
                        rl2.add(new ResultSet(new Result[][]{tr}), score);
                    }
                    ++j;
                }
                ++s;
            }
        }
        return new TBSScanner.ResultList[]{rl, rl2};
    }

    private static Pair<int[][], Sequence[]> readNextSequences(BufferedReader read, StringBuffer lastHeader) throws Exception {
        String str = null;
        StringBuffer line = new StringBuffer();
        IntList starts = new IntList();
        IntList ends = new IntList();
        LinkedList<SparseSequence> seqs = new LinkedList<SparseSequence>();
        Pattern acgt = Pattern.compile("[ACGT]+", 2);
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        while ((str = read.readLine()) != null || line.length() > 0) {
            if (str != null) {
                str = str.trim();
            }
            if (str == null || str.startsWith(">")) {
                String header = lastHeader.toString();
                if (str != null) {
                    lastHeader.delete(0, lastHeader.length());
                    lastHeader.append(str.substring(1));
                }
                if (line.length() <= 0) continue;
                String seqStr = line.toString();
                line.delete(0, line.length());
                Matcher match = acgt.matcher(seqStr);
                while (match.find()) {
                    int start = match.start();
                    int end = match.end();
                    SequenceAnnotation annotation = new SequenceAnnotation("unparsed comment line", "unparsed comment line", new CategoricalResult("unparsed comment", "unparsed comment", header));
                    Sequence seq = new SparseSequence((AlphabetContainer)DNAAlphabetContainer.SINGLETON, seqStr.substring(start, end));
                    seq = seq.annotate(false, annotation);
                    seqs.add((SparseSequence)seq);
                    starts.add(start);
                    ends.add(seqStr.length() - end);
                }
                return new Pair<int[][], Sequence[]>(new int[][]{starts.toArray(), ends.toArray()}, seqs.toArray(new Sequence[0]));
            }
            line.append(str);
        }
        return null;
    }

    private static HashSet<Sequence> makeHash(DataSet d) {
        HashSet<Sequence> set = new HashSet<Sequence>();
        int i = 0;
        while (i < d.getNumberOfElements()) {
            set.add(d.getElementAt(i));
            ++i;
        }
        return set;
    }

    public static class TBSScannerLongParameterSet
    extends ParameterSet {
        public TBSScannerLongParameterSet() throws Exception {
            this.parameters.add(new Parameter[]{new SelectionParameter(DataType.PARAMETERSET, new String[]{"Use a previously uploaded file", "Paste sequences in FastA format"}, new ParameterSet[]{new SimpleParameterSet(new FileParameter("FastA file", "The sequences to scan for TAL effector target sites, FastA format", "fasta", true)), new SimpleParameterSet(new MultilineSimpleParameter("FastA sequences", "The sequences to scan for TAL effector target sites, FastA format", true))}, "Input sequences", "You can either use a previously uploaded file (see task &quot;GetData&quot; -&gt; &quot;Upload File&quot;) or paste in sequences in FastA format", true)});
            this.parameters.add(new Parameter[]{new MultilineSimpleParameter("RVD sequence", "Sequence of RVDs, seperated by '-'", true, "NI-HD-HD-NG-NN-NK-NK")});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "Maximum number of target sites", "Limits the total number of reported target sites in all input sequences, ranked by their score.", true, new NumberValidator<Integer>(1, 10000), 100)});
        }

        public Parameter[] getAllParameters() {
            return (Parameter[])this.parameters.toArray(new Parameter[0]);
        }

        public void addParameter(int i, Parameter par) {
            this.parameters.add(i, par);
        }

        public String getTALSequence() {
            return (String)((Parameter)this.parameters.get("RVD sequence")).getValue();
        }

        public void setInputPath(String path) throws Exception {
            ((SelectionParameter)this.parameters.get("Input sequences")).setValue("Use a previously uploaded file");
            ((FileParameter)((SimpleParameterSet)((SelectionParameter)this.parameters.get("Input sequences")).getValue()).getParameterAt(0)).setValue(new FileParameter.FileRepresentation(path));
        }

        public BufferedReader getInputSequences() throws Exception {
            if (((SelectionParameter)this.parameters.get("Input sequences")).getSelected() == 0) {
                String filename = (String)((SimpleParameterSet)((SelectionParameter)this.parameters.get("Input sequences")).getValue()).getParameterAt(0).getValue();
                return new BufferedReader(new FileReader(filename));
            }
            String content = (String)((SimpleParameterSet)((SelectionParameter)this.parameters.get("Input sequences")).getValue()).getParameterAt(0).getValue();
            return new BufferedReader(new StringReader(content));
        }

        public int getN() {
            return (Integer)((Parameter)this.parameters.get("Maximum number of target sites")).getValue();
        }
    }
}

