/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.rng.RandomStream;

public abstract class StochasticProcess {
    protected boolean observationTimesSet = false;
    protected double x0 = 0.0;
    protected int d = 1;
    protected int observationIndex = 0;
    protected int observationCounter = 0;
    protected double[] t;
    public double[] path;
    protected int[] observationIndexFromCounter;

    public void setObservationTimes(double[] t, int d) {
        if (d <= 0) {
            throw new IllegalArgumentException("Number of observation times d <= 0");
        }
        this.d = d;
        this.observationTimesSet = true;
        this.t = new double[d + 1];
        System.arraycopy(t, 0, this.t, 0, d + 1);
        for (int i = 0; i < d; ++i) {
            if (!(t[i + 1] < t[i])) continue;
            throw new IllegalArgumentException("Observation times t[] are not ordered chronologically");
        }
        this.path = new double[d + 1];
        this.init();
    }

    public void setObservationTimes(double delta, int d) {
        this.t = new double[d + 1];
        this.t[0] = 0.0;
        for (int i = 1; i <= d; ++i) {
            this.t[i] = (double)i * delta;
        }
        this.setObservationTimes(this.t, d);
    }

    public double[] getObservationTimes() {
        return this.t;
    }

    public int getNbObservationTimes() {
        return this.d;
    }

    public abstract double[] generatePath();

    public double[] generatePath(RandomStream stream) {
        this.setStream(stream);
        return this.generatePath();
    }

    public double[] getPath() {
        return this.path;
    }

    public void getSubpath(double[] subpath, int[] pathIndices) {
        for (int j = 0; j < subpath.length; ++j) {
            subpath[j] = this.path[pathIndices[j]];
        }
    }

    public double getObservation(int j) {
        return this.path[j];
    }

    public void resetStartProcess() {
        this.observationIndex = 0;
        this.observationCounter = 0;
    }

    public boolean hasNextObservation() {
        return this.observationCounter < this.d;
    }

    public double nextObservation() {
        throw new UnsupportedOperationException("Method not defined in this class");
    }

    public int getCurrentObservationIndex() {
        return this.observationIndex;
    }

    public double getCurrentObservation() {
        return this.path[this.observationIndex];
    }

    public double getX0() {
        return this.x0;
    }

    public abstract void setStream(RandomStream var1);

    public abstract RandomStream getStream();

    protected void init() {
        if (this.observationTimesSet) {
            this.path[0] = this.x0;
        }
    }

    public int[] getArrayMappingCounterToIndex() {
        return this.observationIndexFromCounter;
    }
}

