// Copyright (c) 2016 Northrop Grumman.
// All rights reserved.

/* Palettes for graphics.
* 0 -> Liz's palette (original ImmPort color scheme for graphics)
* 1 -> Cris's palette (diverging)
* 2 -> Christmas (diverging)
* 3 -> not Christmas (sequential color blind friendly)
* 4 -> Rainbow (sequential)
* arrays are color HEX, color RGB (for transparency effect), contrasting color, darker shade for borders
*/
var color_palette = [[
  ['#000000','rgba(0,0,0,','rgba(52,17,81,1)','#111111'],
	['#FF0000','rgba(255,0,0,','rgba(52,17,81,1)','#D21111'],
	['#FFFF00','rgba(255,255,0,','rgba(52,17,81,1)','#FFC900'],
	['#008000','rgba(0,128,0,','rgba(52,17,81,1)','#016D01'],
	['#0000FF','rgba(0,0,255,','rgba(255,0,0,1)','#2121A0'],
	['#FFA500','rgba(255,165,0,','rgba(52,17,81,1)','#DE991B'],
	['#8A2BE2','rgba(138,43,226,','rgba(52,17,81,1)','#6A0EBF'],
	['#808000','rgba(128,128,0,','rgba(52,17,81,1)','#66660A'],
	['#00FFFF','rgba(0,255,255,','rgba(52,17,81,1)','#1DCBCB'],
	['#FF00FF','rgba(255,0,255,','rgba(52,17,81,1)','#A009A0'],
	['#00FF00','rgba(0,255,0,','rgba(52,17,81,1)','#20AB20'],
	['#000080','rgba(0,0,128,','rgba(255,0,0,1)','#13135B'],
	['#F08080','rgba(240,128,128,','rgba(52,17,81,1)','#922626'],
	['#800080','rgba(128,0,128,','rgba(255,0,0,1)','#580B58'],
	['#F0E68C','rgba(240,230,140,','rgba(52,17,81,1)','#F0C08C'],
	['#8FBC8F','rgba(143,188,143,','rgba(52,17,81,1)','#668166'],
	['#2F4F4F','rgba(47,79,79,','rgba(52,17,81,1)','#0E3636'],
	['#008080','rgba(0,128,128,','rgba(52,17,81,1)','#095454'],
	['#9932CC','rgba(153,50,204,','rgba(52,17,81,1)','#78289F'],
	['#FF7F50','rgba(255,127,80,','rgba(52,17,81,1)','#B0431A'],
	['#FFD700','rgba(255,215,0,','rgba(52,17,81,1)','#FFB900'],
	['#008B8B','rgba(0,139,139,','rgba(52,17,81,1)','#097171'],
	['#800000','rgba(128,0,0,','rgba(255,0,0,1)','#500303'],
	['#5F9EA0','rgba(95,158,160,','rgba(52,17,81,1)','#366668'],
	['#FFC0CB','rgba(255,192,203,','rgba(52,17,81,1)','#FC869B'],
	['#545454','rgba(84,84,84,','rgba(255,0,0,1)','#342C2C'],
	['#7FFFD4','rgba(127,255,212,','rgba(255,0,0,1)','#8CCAB5'],
	['#ADD8E6','rgba(173,216,230,','rgba(52,17,81,1)','#77C6DF'],
	['#DB7093','rgba(219,112,147,','rgba(52,17,81,1)','#B24B6D'],
	['#CD853F','rgba(205,133,63,','rgba(52,17,81,1)','#BA6D22'],
	['#4169E1','rgba(65,105,225,','rgba(52,17,81,1)','#1840B8'],
	['#708090','rgba(112,128,144,','rgba(52,17,81,1)','#465A6D'],
	['#4682B4','rgba(70,130,180,','rgba(52,17,81,1)','#1F5785'],
	['#D8BFD8','rgba(216,191,216,','rgba(52,17,81,1)','#B679B6'],
	['#F5DEB3','rgba(245,222,179,','rgba(52,17,81,1)','#E9AB3F'],
	['#9ACD32','rgba(154,205,50,','rgba(52,17,81,1)','#6E971B'],
	['#BDB76B','rgba(189,183,107,','rgba(52,17,81,1)','#938E49'],
	['#8B008B','rgba(139,0,139,','rgba(255,0,0,1)','#590A59'],
	['#556B2F','rgba(85,107,47,','rgba(52,17,81,1)','#3A4D19'],
	['#00CED1','rgba(0,206,209,','rgba(52,17,81,1)','#1BA0A2'],
	['#FF1493','rgba(255,20,147,','rgba(52,17,81,1)','#A40F5F']
],[
	//cris
  ['#000000','rgba(0,0,0,','rgba(52,17,81,1)','#111111'],
	['#5B1A48','rgba(91,26,72,','rgba(255,0,0,1)','#922B74'],
	['#1ED992','rgba(30,217,146,','rgba(52,17,81,1)','#108A5B'],
	['#FFE4FF','rgba(255,228,255,','rgba(52,17,81,1)','#FF9AFF'],
	['#3B2000','rgba(59,32,0,','rgba(255,0,0,1)','#8C4D02'],
	['#BDF765','rgba(189,247,101,','rgba(52,17,81,1)','#83b438'],
	['#C6DCFD','rgba(198,220,253,','rgba(52,17,81,1)','#70A9FE'],
	['#542788','rgba(84,39,136,','rgba(255,0,0,1)','#8055B2'],
	['#FB8072','rgba(251,128,114,','rgba(52,17,81,1)','#D55446'],
	['#F2E0B8','rgba(242,224,184,','rgba(52,17,81,1)','#F9C146'],
	['#0A684C','rgba(10,104,76,','rgba(52,17,81,1)','#27B88D'],
	['#FD8ADC','rgba(253,138,220,','rgba(52,17,81,1)','#CB3AA2'],
	['#CDFAFF','rgba(205,250,255,','rgba(52,17,81,1)','#66EDFC'],
	['#0C1657','rgba(12,22,87,','rgba(255,0,0,1)','#3243B6'],
	['#FFDE69','rgba(255,222,105,','rgba(52,17,81,1)','#CFAD34'],
	['#BEBADA','rgba(190,186,218,','rgba(52,17,81,1)','#6A5EBA'],
	['#8D182B','rgba(141,24,43,','rgba(52,17,81,1)','#5E0412'],
	['#FFFF00','rgba(255,255,0,','rgba(52,17,81,1)','#FFC900'],
	['#788D84','rgba(120,141,132,','rgba(52,17,81,1)','#496F5F'],
	['#A53DD5','rgba(165,61,213,','rgba(52,17,81,1)','#66178A'],
	['#5DF33F','rgba(93,243,63,','rgba(52,17,81,1)','#47A035'],
	['#C8C8C8','rgba(200,200,200,','rgba(52,17,81,1)','#878484'],
	['#9A1B7D','rgba(154,27,125,','rgba(52,17,81,1)','#D54BB5'],
	['#1068BD','rgba(16,104,189,','rgba(52,17,81,1)','#0C3156'],
	['#C7EAE5','rgba(199,234,229,','rgba(52,17,81,1)','#68B8AC'],
	['#8C510A','rgba(140,81,10,','rgba(52,17,81,1)','#653B07'],
	['#FFBD01','rgba(255,189,1,','rgba(52,17,81,1)','#CE9800'],
	['#DFFCC5','rgba(223,252,197,','rgba(52,17,81,1)','#99C670'],
	['#41C8C4','rgba(65,200,196,','rgba(52,17,81,1)','#24918E'],
	['#9685F5','rgba(150,133,245,','rgba(52,17,81,1)','#6257A1'],
	['#D8B365','rgba(216,179,101,','rgba(52,17,81,1)','#9F7E39'],
	['#00FFFF','rgba(0,255,255,','rgba(52,17,81,1)','#1DCBCB'],
	['#F1F1A2','rgba(241,241,162,','rgba(52,17,81,1)','#CECE54'],
	['#AFBFFD','rgba(175,191,253,','rgba(52,17,81,1)','#5E72BF'],
	['#FF0019','rgba(255,0,25,','rgba(52,17,81,1)','#970110'],
	['#8A598A','rgba(138,89,138,','rgba(52,17,81,1)','#602E60'],
	['#75B030','rgba(117,176,48,','rgba(52,17,81,1)','#3D690A'],
	['#0A5A83','rgba(10,90,131,','rgba(52,17,81,1)','#0F3447'],
	['#937B6A','rgba(147,123,106,','rgba(52,17,81,1)','#473121'],
	['#1540EC','rgba(21,64,236,','rgba(255,0,0,1)','#0C2589'],
	['#010101','rgba(1,1,1,','rgba(255,0,0,1)','#4A4242']
],[
	//christmas
  ['#000000','rgba(0,0,0,','rgba(52,17,81,1)','#111111'],
	['#BD1A00','rgba(189,26,0,','rgba(52,17,81,1)','#7B1E0F'],
	['#FF8F68','rgba(255,143,104,','rgba(52,17,81,1)','#BC4F28'],
	['#FFFFBF','rgba(255,255,191,','rgba(52,17,81,1)','#EAEA72'],
	['#1A9850','rgba(26,152,80,','rgba(52,17,81,1)','#0F582F'],
	['#BDF765','rgba(189,247,101,','rgba(52,17,81,1)','#73B70C'],
	['#542788','rgba(84,39,136,','rgba(255,0,0,1)','#230941'],
	['#998EC3','rgba(153,142,195,','rgba(52,17,81,1)','#483884'],
	['#D8DAEB','rgba(216,218,235,','rgba(52,17,81,1)','#7581E9'],
	['#5A95B8','rgba(90,149,184,','rgba(52,17,81,1)','#154C6C'],
	['#01555E','rgba(1,85,94,','rgba(255,0,0,1)','#04272A'],
	['#FEE0B6','rgba(254,224,182,','rgba(52,17,81,1)','#C8954F'],
	['#F1A340','rgba(241,163,64,','rgba(52,17,81,1)','#BD7519'],
	['#B35806','rgba(179,88,6,','rgba(52,17,81,1)','#683303'],
	['#8D182B','rgba(141,24,43,','rgba(52,17,81,1)','#5B0B18'],
	['#EF8AB4','rgba(239,138,180,','rgba(52,17,81,1)','#E7337E'],
	['#C51B7D','rgba(197,27,125,','rgba(52,17,81,1)','#690840'],
	['#3B2000','rgba(59,32,0,','rgba(255,0,0,1)','#120A00'],
	['#8C510A','rgba(140,81,10,','rgba(52,17,81,1)','#442907'],
	['#D8B365','rgba(216,179,101,','rgba(52,17,81,1)','#816426'],
	['#C7EAE5','rgba(199,234,229,','rgba(52,17,81,1)','#54AB9F'],
	['#41B6C4','rgba(65,182,196,','rgba(52,17,81,1)','#167D89'],
	['#225EA8','rgba(34,94,168,','rgba(52,17,81,1)','#103B6F'],
	['#0C1657','rgba(12,22,87,','rgba(255,0,0,1)','#030933'],
	['#00FF00','rgba(0,255,0,','rgba(52,17,81,1)','#20AB20'],
	['#FF0000','rgba(255,0,0,','rgba(52,17,81,1)','#D21111'],
	['#AFAFAF','rgba(175,175,175,','rgba(52,17,81,1)','#818D8D'],
	['#FFFF00','rgba(255,255,0,','rgba(52,17,81,1)','#FFC900'],
	['#FF00DB','rgba(255,0,219,','rgba(52,17,81,1)','#A70C91'],
	['#0000FF','rgba(0,0,255,','rgba(255,0,0,1)','#2121A0'],
	['#00FFFF','rgba(0,255,255,','rgba(52,17,81,1)','#1DCBCB'],
	['#95E199','rgba(149,225,153,','rgba(52,17,81,1)','#369F3B'],
	['#A53DD5','rgba(165,61,213,','rgba(52,17,81,1)','#590480'],
	['#1A4A26','rgba(26,74,38,','rgba(255,0,0,1)','#08240F'],
	['#FCCDE5','rgba(252,205,229,','rgba(52,17,81,1)','#D082AA'],
	['#FDB462','rgba(255,222,105,','rgba(52,17,81,1)','#D77C15'],
	['#FFDE69','rgba(253,180,98,','rgba(52,17,81,1)','#E6B505'],
	['#80B1D3','rgba(128,177,211,','rgba(52,17,81,1)','#306E99'],
	['#737B1B','rgba(115,123,27,','rgba(52,17,81,1)','#424705'],
	['#BEBADA','rgba(190,186,218,','rgba(52,17,81,1)','#514984'],
	['#8DD3C7','rgba(141,211,199,','rgba(52,17,81,1)','#248D7B']
],[
// Not christmas
  ['#000000','rgba(0,0,0,','rgba(52,17,81,1)','#111111'],
	['#781C81','rgba(120,28,129,','rgba(255,0,0,1)','#49074F'],
	['#61187E','rgba(97,24,126,','rgba(255,0,0,1)','#3B0251'],
	['#531B7F','rgba(83,27,127,','rgba(255,0,0,1)','#320356'],
	['#4A2384','rgba(74,35,132,','rgba(255,0,0,1)','#260656'],
	['#442E8A','rgba(68,46,138,','rgba(255,0,0,1)','#1E0A5C'],
	['#413B93','rgba(65,59,147,','rgba(255,0,0,1)','#18125E'],
	['#3F499D','rgba(63,73,157,','rgba(255,0,0,1)','#17206F'],
	['#3F58A8','rgba(63,88,168,','rgba(255,0,0,1)','#11276C'],
	['#4066B2','rgba(64,102,178,','rgba(255,0,0,1)','#16377B'],
	['#4273BB','rgba(66,115,187,','rgba(255,0,0,1)','#13438A'],
	['#447FC0','rgba(68,127,192,','rgba(52,17,81,1)','#164F8E'],
	['#488AC2','rgba(72,138,194,','rgba(52,17,81,1)','#195A92'],
	['#4C94BF','rgba(76,148,191,','rgba(52,17,81,1)','#1C6490'],
	['#519CB8','rgba(81,156,184,','rgba(52,17,81,1)','#1E6D8B'],
	['#57A3AE','rgba(87,163,174,','rgba(52,17,81,1)','#287985'],
	['#5EA9A2','rgba(94,169,162,','rgba(52,17,81,1)','#277A72'],
	['#65AE95','rgba(101,174,149,','rgba(52,17,81,1)','#28785D'],
	['#6DB388','rgba(109,179,136,','rgba(52,17,81,1)','#348252'],
	['#76B67D','rgba(118,182,125,','rgba(52,17,81,1)','#388340'],
	['#7FB972','rgba(127,185,114,','rgba(52,17,81,1)','#448635'],
	['#88BB69','rgba(136,187,105,','rgba(52,17,81,1)','#518730'],
	['#92BD60','rgba(146,189,96,','rgba(52,17,81,1)','#62902D'],
	['#9CBE59','rgba(156,190,89,','rgba(52,17,81,1)','#6D9028'],
	['#A7BE53','rgba(167,190,83,','rgba(52,17,81,1)','#70871D'],
	['#B1BE49','rgba(177,190,78,','rgba(52,17,81,1)','#7C8919'],
	['#BABC49','rgba(186,188,73,','rgba(52,17,81,1)','#87891B'],
	['#C3BA45','rgba(195,186,69,','rgba(52,17,81,1)','#928917'],
	['#CCB742','rgba(204,183,66,','rgba(52,17,81,1)','#AC9516'],
	['#D3B33F','rgba(211,179,63,','rgba(52,17,81,1)','#A78713'],
	['#DAAD3C','rgba(218,173,60,','rgba(52,17,81,1)','#AB7E0D'],
	['#DFA539','rgba(223,165,57,','rgba(52,17,81,1)','#B17609'],
	['#E39C37','rgba(227,156,55,','rgba(52,17,81,1)','#BB730D'],
	['#E59134','rgba(229,145,52,','rgba(52,17,81,1)','#B16006'],
	['#E78432','rgba(231,132,50,','rgba(52,17,81,1)','#B45404'],
	['#E7752F','rgba(231,117,47,','rgba(52,17,81,1)','#763703'],
	['#E6652D','rgba(230,101,45,','rgba(52,17,81,1)','#AD3906'],
	['#E4542A','rgba(228,84,42,','rgba(52,17,81,1)','#AE2A04'],
	['#E14326','rgba(225,67,38,','rgba(52,17,81,1)','#AD1E04'],
	['#DD3123','rgba(221,49,35,','rgba(52,17,81,1)','#A11105'],
	['#D92120','rgba(217,33,32,','rgba(52,17,81,1)','#8A0201']
],[
// Rainbow
  ['#000000','rgba(0,0,0,','rgba(52,17,81,1)','#111111'],
	['#FF0000','rgba(255,0,0,','rgba(52,17,81,1)','#C30707'],
	['#FF2600','rgba(255,38,0,','rgba(52,17,81,1)','#BA250B'],
	['#FF4D00','rgba(255,77,0,','rgba(52,17,81,1)','#BD3A02'],
	['#FF7300','rgba(255,115,0,','rgba(52,17,81,1)','#C15B06'],
	['#FF9900','rgba(255,153,0,','rgba(52,17,81,1)','#BF7504'],
	['#FFBF00','rgba(255,191,0,','rgba(52,17,81,1)','#C49405'],
	['#FFE500','rgba(255,229,0,','rgba(52,17,81,1)','#BEAB01'],
	['#F2FF00','rgba(242,255,0,','rgba(52,17,81,1)','#B3BD03'],
	['#CCFF00','rgba(204,255,0,','rgba(52,17,81,1)','#93B607'],
	['#A6FF00','rgba(166,255,0,','rgba(52,17,81,1)','#7BBB05'],
	['#80FF00','rgba(128,255,0,','rgba(52,17,81,1)','#59AC05'],
	['#59FF00','rgba(89,255,0,','rgba(52,17,81,1)','#3DAD01'],
	['#33FF00','rgba(51,255,0,','rgba(52,17,81,1)','#24B001'],
	['#0DFF00','rgba(13,255,0,','rgba(52,17,81,1)','#0CAA03'],
	['#00FF1A','rgba(0,255,26,','rgba(52,17,81,1)','#03AC14'],
	['#00FF40','rgba(0,255,64,','rgba(52,17,81,1)','#02AB2C'],
	['#00FF66','rgba(0,255,102,','rgba(52,17,81,1)','#01AD46'],
	['#00FF8C','rgba(0,255,140,','rgba(52,17,81,1)','#06B466'],
	['#00FFB3','rgba(0,255,179,','rgba(52,17,81,1)','#01AB79'],
	['#00FFD9','rgba(0,255,217,','rgba(52,17,81,1)','#02B399'],
	['#00FFFF','rgba(0,255,255,','rgba(52,17,81,1)','#04AEAE'],
	['#00D9FF','rgba(0,217,255,','rgba(52,17,81,1)','#0496B0'],
	['#00B2FF','rgba(0,178,255,','rgba(52,17,81,1)','#0272A3'],
	['#008CFF','rgba(0,140,255,','rgba(255,0,0,1)','#00569D'],
	['#0068FF','rgba(0,102,255,','rgba(255,0,0,1)','#044AAE'],
	['#0040FF','rgba(0,64,255,','rgba(255,0,0,1)','#032894'],
	['#0019FF','rgba(0,25,255,','rgba(255,0,0,1)','#01109C'],
	['#0D00FF','rgba(13,0,255,','rgba(255,0,0,1)','#0B03A7'],
	['#3300FF','rgba(51,0,255,','rgba(255,0,0,1)','#2403A7'],
	['#5900FF','rgba(89,0,255,','rgba(255,0,0,1)','#3E04AA'],
	['#8000FF','rgba(128,0,255,','rgba(255,0,0,1)','#5302A4'],
	['#A600FF','rgba(166,0,255,','rgba(255,0,0,1)','#6F03A9'],
	['#CC00FF','rgba(204,0,255,','rgba(255,0,0,1)','#8A04AC'],
	['#F200FF','rgba(242,0,255,','rgba(52,17,81,1)','#9D03A5'],
	['#FF00E5','rgba(255,0,229,','rgba(52,17,81,1)','#B607A4'],
	['#FF00BF','rgba(255,0,191,','rgba(52,17,81,1)','#B40588'],
	['#FF0099','rgba(255,0,153,','rgba(52,17,81,1)','#B4016D'],
	['#FF0073','rgba(255,0,115,','rgba(52,17,81,1)','#A9024D'],
	['#FF004C','rgba(255,0,76,','rgba(52,17,81,1)','#A90335'],
	['#FF0026','rgba(255,0,38,','rgba(52,17,81,1)','#A6051D']
]];
