import sys
import warnings
import argparse
from Bio import SeqIO, SeqRecord, BiopythonWarning
from Bio.Seq import Seq
from Bio.Alphabet import IUPAC


warnings.simplefilter("ignore", BiopythonWarning)
parser = argparse.ArgumentParser(description="Translation")
parser.add_argument('-r', action='store', dest='read_frame', type=int)
parser.add_argument('-i', action='store', dest='input_file')
parser.add_argument('-o', action='store', dest='output_file')

inputs = parser.parse_args()
with open(inputs.output_file, 'w') as f:
    for seq_record in SeqIO.parse(inputs.input_file, 'fasta'):
        seqid = seq_record.id
        name=seq_record.name
        description = seq_record.description
        if inputs.read_frame > 0:
            seq_record = seq_record[(inputs.read_frame - 1):]
        elif inputs.read_frame == -1:
            seq_record = seq_record.reverse_complement()
        elif inputs.read_frame == -2:
            seq_record = seq_record.reverse_complement()
            seq_record = seq_record[2:]
        elif inputs.read_frame == -3:
            seq_record = seq_record.reverse_complement()
            seq_record = seq_record[1:]
        dna = Seq(str(seq_record.seq), IUPAC.ambiguous_dna)
        protein = SeqRecord.SeqRecord(seq=dna.translate(), id=seqid, name=name, description=description)
        SeqIO.write(protein, f, 'fasta')
        f.write('\n')
f.close()
