#/bin/perl                                                                                                                                                                         
#
#------------------------------------------------------------------------------
#                         University of Minnesota
#      Copyright 2010 - 2011, Regents of the University of Minnesota
#------------------------------------------------------------------------------
# Author:
#
#  Jesse Erdmann
#
# POD documentation
#------------------------------------------------------------------------------
=pod BEGIN

=head1 NAME

  list_projects.pl - TAPDANCE utility to list projects in the database

 TAPDANCE functionality.

=head1 SYNOPSIS

   list_projects.pl [-help]

    See http://sf.net/p/tapdancebio for full documentation

=head1 OPTIONS

=over 6

=item  B<-help>

  Print this usage summary.

=item B<-user username>

  Filter projects based on the user that created the project.

=item B<-tag tags>

  Any number of tags may be specified to filter projects where at least
   one of the tags has been specified as a metadata element for a library 
   within the project.

=back

=cut

#### END of POD documentation.
#-----------------------------------------------------------------------------
use strict;
use Getopt::Long;
use Pod::Usage;

my $path = $0;
$path =~ s/\/\w*\.pl$//g;
require "$path/tapdance_base_config.pl";
require "$path/project_man.pl";
require "$path/util.pl";

my $user = "cmd_line";
my ($out_file, $help_flag);
my @tags = ();
my $query_type = "all";
my $db_config;
my %options = (
    "user|u=s"     => \$user,
    "tag=s"        => \@tags,
    "query_type=s" => \$query_type,
    "db_config=s"  => \$db_config,
    "help"         => \$help_flag
);

GetOptions(%options) or pod2usage(2);
pod2usage(1) if $help_flag;

if (defined($db_config)) {
    my $db_cnf_path = $path . "/" . $db_config;
    require "$db_cnf_path";
}

$user = &sanitize_project($user);

my $projects_ref = &get_project_list($user, $query_type, @tags);
foreach my $project (@{$projects_ref}) {
    my $full_name = $project;
    $project =~ s/$user//;
    print "$full_name\t$project\n";
}

exit;
