use DBI;

#####
# Database configuration
#####
#
# Specify the username to connect to the database as
#$db_username="MY_DB_USERNAME";
#
# Specify the password for the DB user
#$db_password="MY_DB_PASSWORD";
#
# The software running the application
#   Currently supported:
#   * MySQL (Several database operations use MySQL specific SQL)
#$db_type='mysql';
#
# The machine name or IP address to connect to the database on 
#$db_host="127.0.0.1";
#
# The port that the database is listening to on the host
#$db_port='3306';
#
# The database to use for TAPDANCE
#$db_name="MY_TAPDANCE_DB";
#$db_name="MY_DB";
#
# Collapse db config to a single connection string
#$data_source = "dbi:$db_type:dbname=$db_name:$db_host;mysql_local_infile=1:$db_port";
#
# Connect to the daatbase, running 'perl ./tabdance_base_config.pl
#  can be used to verfiy the database configuration 
#$dbh = DBI->connect($data_source, $db_username, $db_password, { RaiseError => 1, AutoCommit => 0 });
#
# The name of the table to collect top level project information 
$project_table_name = "TAPDANCE_project_master";

#####
# Required project dependant config variables
#####
#  Project Name
#$proj = 'ProjName'; 

#  Environment Directory or the top level directory for the project
#  Contents will be as follows
#  * CIS (directory containing intermediary files generated during CIS calculation)
#  * config.pl (this file)
#  * data (data inputs)
#    * barcode2lib.txt (barcode to library name mapping, phase 1)
#    * seq.tab (tabular sequence data, phase 1)
#  * FISH (directory containing intermediary files generated during Fisher exact tests)
#  * lib (executable code and some resources used by code)
#  * mapping (directory containing intermediary files generated during mapping to the reference genome)
#  * results (directory containing final outputs)
#$envDir = 'DirectoryName';

#####
# Config variables for insertion analysis
#####
# Specify the alignment

# Specify the bowtie command to use, useful if you want to use a specific bowtie version not on the path 
#  or would like special options.  For example, to quiet bowtie output. Defaults to 'bowtie' on user $PATH
$bowtie_exe='bowtie --quiet';

# Specify the genome idnex to use, should be a full path excluding the file extension or just the name of 
#  the genome index if the index is in the indexes folder of the bowtie installation. Defaults to 'mm9'
#$bowtie_idx = '/project/ccbioinf/Software/bowtie_indexes/mus_musculus_ncbi37';
$bowtie_idx='mm9';

# Specify the IRDR string to use, see common options below, defaults to a Sleeping Beauty mutagen
#  '__GTATGTAAACTTCCGACTTCAACTG' 
$mutagens="__GTATGTAAACTTCCGACTTCAACTG";

#####
# Config variables for CIS calling
#####
# The interval file of features to annotate CIS calls with
$annotation_file="lib/mm9.bed";
#
$library_percent ='0.0001';
#
$CIS_total_pvalue = '0.05';
$CIS_library_pvalue = '0.05';
$CIS_region_pvalue = '0.05';
#
$cocis_threshold ='0.001';

