/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Stack;

public class NewickParser {
    private String newick = new String();
    private Stack<Node> currentnode = new Stack();
    private Node node = new Node();
    private int position = 0;
    private boolean firstpass;

    public NewickParser() {
        this.currentnode.push(this.node);
        this.firstpass = true;
    }

    public void parseTree() {
        String string;
        if (this.newick == null || this.newick.equals("")) {
            System.out.println("Please load a tree before using the parsetree method");
            System.exit(1);
        }
        if (!this.checkBrackets()) {
            System.out.println("There is a ')' in the wrong place in this tree");
            System.exit(1);
        }
        this.newick = string = this.newick.replace(" ", "");
        int n = this.newick.length();
        char c = this.newick.charAt(n - 1);
        if (c != ';') {
            System.out.println("Tree does not end in a ';'");
            System.exit(1);
        }
        this.scanNode();
    }

    private void scanNode() {
        if (this.getCurrentChar() == '(') {
            this.scanInternalNode();
        } else if (this.getCurrentChar() != ';') {
            this.getLeafLabel();
        } else {
            System.out.println("Found a ; in the wrong place in tree");
            System.exit(1);
        }
    }

    private void scanInternalNode() {
        Node node;
        ++this.position;
        if (this.firstpass) {
            this.firstpass = false;
        } else {
            node = new Node();
            Node node2 = this.currentnode.pop();
            node2.addChild(node);
            this.currentnode.push(node2);
            this.currentnode.push(node);
        }
        this.scanNode();
        while (this.getCurrentChar() != ')') {
            if (this.getCurrentChar() == ',') {
                ++this.position;
            }
            this.scanNode();
        }
        ++this.position;
        if (this.getCurrentChar() != ',' && this.getCurrentChar() != ')' && this.getCurrentChar() != ';') {
            node = this.currentnode.pop();
            node.setName(this.getLabel());
            this.currentnode.push(node);
        }
        if (this.getCurrentChar() == ':') {
            ++this.position;
            node = this.currentnode.pop();
            node.setLength(this.getLength());
            this.currentnode.push(node);
        }
        this.currentnode.pop();
    }

    private String getLabel() {
        String string = new String();
        int n = this.getNodeEnd();
        int n2 = this.newick.indexOf(58, this.position);
        if (n2 >= 0 && n2 < n) {
            n = n2;
        }
        string = this.newick.substring(this.position, n);
        this.position = n;
        return string;
    }

    private void getLeafLabel() {
        String string = this.getLabel();
        Node node = new Node();
        node.setName(string);
        node.setType("leaf");
        if (this.getCurrentChar() == ':') {
            ++this.position;
            node.setLength(this.getLength());
        }
        Node node2 = this.currentnode.pop();
        node2.addChild(node);
        this.currentnode.push(node2);
    }

    private double getLength() {
        int n = this.getNodeEnd();
        double d = 0.0;
        String string = this.newick.substring(this.position, n);
        try {
            d = Double.valueOf(string);
        }
        catch (Exception exception) {
            System.out.println("Error reading branch length");
            System.exit(1);
        }
        this.position = n;
        return d;
    }

    public int getNodeEnd() {
        int n = this.newick.indexOf(44, this.position);
        int n2 = this.newick.indexOf(59, this.position);
        int n3 = this.newick.indexOf(41, this.position);
        int n4 = this.newick.indexOf(40, this.position);
        int n5 = this.newick.length();
        if (n >= 0) {
            n5 = n;
        }
        if (n2 >= 0 && n2 < n5) {
            n5 = n2;
        }
        if (n3 >= 0 && n3 < n5) {
            n5 = n3;
        }
        if (n4 >= 0 && n4 < n5) {
            System.out.println("Found opening bracket in wrong place when detecting node end");
            System.exit(1);
        }
        return n5;
    }

    private char getCurrentChar() {
        if (this.position > this.newick.length()) {
            System.out.println("Position counter off scale of tree string");
            System.exit(1);
        }
        char c = this.newick.charAt(this.position);
        return c;
    }

    public void readFile(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = new String();
            while ((string2 = bufferedReader.readLine()) != null) {
                string3 = string3 + string2;
            }
            bufferedReader.close();
            this.newick = string3;
        }
        catch (Exception exception) {
            System.err.println("File input error, please make sure file name is the first arguement");
        }
    }

    public void setString(String string) {
        this.newick = string;
    }

    private boolean checkBrackets() {
        int n = 0;
        for (int i = 0; i < this.newick.length(); ++i) {
            char c = this.newick.charAt(i);
            if (c == '(') {
                ++n;
            } else if (c == ')') {
                --n;
            }
            if (n >= 0) continue;
            return false;
        }
        return n <= 0;
    }

    public Node getNode() {
        return this.node;
    }
}

