/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Preferences {
    public ArrayList<String> preflist = new ArrayList();
    public String svgfile = "../temp/output.svg";
    public String topologyfile = "../temp/output.tre";
    public String namestopologyfile = "";
    public String ncbitopologyfile = "";
    public String embedfile = "";
    public String embedout = "../temp/embed.txt";
    public String xmlfile = "../temp/output.xml";
    public String treetype = "phylo";
    public String treestyle = "";
    public String names = "none";
    public String link = "";
    public String css = "../scripts/tree.css";
    public String js = "../scripts/tree.js";
    public String buildlink = "";
    public boolean db = false;
    public boolean extra = false;
    public boolean svgtoscreen = false;
    public boolean pagetoscreen = false;
    public int minbrlen = 0;
    public int x = 500;
    public int y = 500;
    public int textsize = 100;
    public int firstrun = 1;

    public Preferences() {
        String string = "preferences.txt";
        this.firstrun = 1;
        this.readPrefs(string);
        this.processPrefs();
        this.firstrun = 0;
    }

    public void readPrefs(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = new String();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.equals("")) continue;
                this.preflist.add(string2);
            }
            if (this.firstrun == 0) {
                System.err.println("Preference file found, setting prefs now...");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            if (this.firstrun == 1) {
                System.err.println("Setting initial default prefs...");
            }
            System.err.println("Preferences file not found, using defaults...");
        }
    }

    public void processPrefs() {
        if (!this.preflist.isEmpty()) {
            for (String string : this.preflist) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                int n = stringTokenizer.countTokens();
                if (n < 2) {
                    System.err.println("Preference file corrupt - should contain 2 words per line");
                    continue;
                }
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                this.setPrefs(string2, string3);
            }
        }
    }

    private void setPrefs(String string, String string2) {
        if (string.equals("svgfile")) {
            this.svgfile = string2;
        } else if (string.equals("topologyfile")) {
            this.namestopologyfile = string2;
        } else if (string.equals("namestopologyfile")) {
            this.topologyfile = string2;
        } else if (string.equals("ncbitopologyfile")) {
            this.ncbitopologyfile = string2;
        } else if (string.equals("xmlfile")) {
            this.xmlfile = string2;
        } else if (string.equals("css")) {
            this.css = string2;
        } else if (string.equals("js")) {
            this.js = string2;
        } else if (string.equals("treetype")) {
            this.treetype = string2;
        } else if (string.equals("treestyle")) {
            this.treestyle = string2;
        } else if (string.equals("link")) {
            this.link = string2;
        } else if (string.equals("embedfile")) {
            this.embedfile = string2;
        } else if (string.equals("textsize")) {
            this.textsize = Integer.parseInt(string2);
        } else if (string.equals("embedout")) {
            this.embedout = string2;
        } else if (string.equals("minbrlen")) {
            this.minbrlen = Integer.parseInt(string2);
        } else if (string.equals("extradata")) {
            this.extra = string2.equals("on");
        } else if (string.equals("svgtoscreen")) {
            this.svgtoscreen = string2.equals("on");
        } else if (string.equals("pagetoscreen")) {
            this.pagetoscreen = string2.equals("on");
        } else if (string.equals("buildlink")) {
            this.buildlink = string2;
        } else if (string.equals("db")) {
            this.db = string2.equals("on");
        } else {
            System.err.println("Error in preference file");
        }
    }
}

