#!/usr/bin/env python

import sys
import argparse as ap
import re
parser = ap.ArgumentParser(prog='kwip_postprocess', conflict_handler='resolve',
                           description="Postprocess galaxy kWIP output")

input = parser.add_argument_group('Input', '')
input.add_argument('-i', '--input', nargs=1, required=True, help="kWIP galaxy OUTPUT")


if len(sys.argv) == 0:
    parser.print_usage()
    sys.exit(1)

args = parser.parse_args()


with open(args.input[0]) as kwip_output:
	with open('kwip_postprocess_output.txt', 'w') as output:
		for line in kwip_output:
                        new_line = re.sub('(_1.fastq(.gz)*|_2.fastq(.gz)*|.fastq(.gz)*)', '', line)
			output.write(new_line)



