#!/usr/bin/env python

"""
VelvetOptimiser Wrapper
Adapted from velveth and velvetg tools in Galaxy
Konrad Paszkiewicz	University of Exeter, UK.

"""
import pkg_resources;
import logging, os, string, sys, tempfile, glob, shutil, types, urllib
import shlex, subprocess
from optparse import OptionParser, OptionGroup
from stat import *


log = logging.getLogger( __name__ )

assert sys.version_info[:2] >= ( 2, 4 )

def stop_err( msg ):
    sys.stderr.write( "%s\n" % msg )
    sys.exit()

def __main__():
    #Parse Command Line
    s = 'oases_optimiser.py:  argv = %s\n' % (sys.argv)
    #print >> sys.stderr, s # so will appear as blurb for file
    argcnt = len(sys.argv)
    starthash = sys.argv[1]
    endhash = sys.argv[2]
    inputs = sys.argv[3]
    contigs = sys.argv[4]
    LastGraph = sys.argv[5]
    afgFile = sys.argv[6]
    unused_reads_fasta = sys.argv[7]
    stats = sys.argv[8]
    othervelvetgoptions = sys.argv[9]
    otheroasesoptions = sys.argv[10]
    transcripts = sys.argv[11]
    splicingevents = sys.argv[12]
    contigordering = sys.argv[13]
    #contigs.extra_files_path

    
    working_dir = '' 
    
    cmdline = '/users/galaxy/galaxyscripts/oases_optimiser.sh %s %s \'%s\' %s %s  2&1>/dev/null' % (starthash, endhash, inputs, othervelvetgoptions, otheroasesoptions)
    #print >> sys.stderr, cmdline # so will appear as blurb for file
    try:
        proc = subprocess.Popen( args=cmdline, shell=True, stderr=subprocess.PIPE )
        returncode = proc.wait()
        # get stderr, allowing for case where it's very large
        stderr = ''
        buffsize = 1048576
        try:
            while True:
                stderr += proc.stderr.read( buffsize )
                if not stderr or len( stderr ) % buffsize != 0:
                    break
        except OverflowError:
            pass
        if returncode != 0:
            raise Exception, stderr
    except Exception, e:
        stop_err( 'Error running oases_optimiser.py' + str( e ) )
    out = open(transcripts,'w')
    transcript_path = os.path.join(working_dir,'transcripts.fa')
    #print >> sys.stderr, path
    for line in open(transcript_path):
        out.write( "%s" % (line) )
    out.close()
 
    out = open(splicingevents,'w')
    path = os.path.join(working_dir,'splicing_events.txt')
    #print >> sys.stderr, contigs_path
    for line in open(path ):
        out.write( "%s" % (line) )
    out.close()

    

    out = open(contigs,'w')
    contigs_path = os.path.join(working_dir,'contigs.fa')
    #print >> sys.stderr, contigs_path
    for line in open(contigs_path ):
        out.write( "%s" % (line) )
    out.close()
    out = open(stats,'w')
    stats_path = os.path.join(working_dir,'stats.txt')
    for line in open( stats_path ):
        out.write( "%s" % (line) )
    out.close()
    if LastGraph != 'None':
        out = open(LastGraph,'w')
        LastGraph_path = os.path.join(working_dir,'LastGraph')
        for line in open( LastGraph_path ):
            out.write( "%s" % (line) )
        out.close()
    if afgFile != 'None':
        out = open(afgFile,'w')
        afgFile_path = os.path.join(working_dir,'oases_asm.afg')
        try:
            for line in open( afgFile_path ):
                out.write( "%s" % (line) )
        except:
            logging.warn( 'error reading %s' %(afgFile_path))
            pass
        out.close()
    if unused_reads_fasta != 'None':
        out = open(unused_reads_fasta,'w')
      	unused_reads_fasta_path = os.path.join(working_dir,'UnusedReads.fa')
        try:
            for line in open( unused_reads_fasta_path ):
                out.write( "%s" % (line) )
        except:
            logging.info( 'error reading %s' %(unused_reads_fasta_path))
            pass
        out.close()

if __name__ == "__main__": __main__()
