
this.ctx = () => context;
var all_contexts = [] ;
var inchidata = {} ;
var all_mix_data = {} ;
var already_sent_data = {} ;

function no_success(tab_index, inchi, data) {
  console.log(`inchikey ${inchi} not found...`) ;
  console.log(`disabling ${data} ...`)
  disable_tab(
    tab_index,
    "red",
    "This compound has not been found on peakforest"
  ) ;
}

function disable_tab(tab_index, color, title) {
  var element = $(`#open_tab_${tab_index}`) ;
  element.attr("disabled", "disabled").off("click");
  element.attr("onclick", null) ;
  element.attr("title", title) ;
  element.attr("data-toggle", null) ;
  element.attr("href", null) ;
  element.css("color", color) ;
  element.css("cursor", "not-allowed") ;
}

function successfull_send_to_pf(bundle, json, index) {
  for (var i = 0 ; i < all_contexts.length ; i += 1) {
    if (all_contexts[i] === null || all_contexts[i] === undefined) {
      continue ;
    }
    if (all_contexts[i].inchikey == bundle["sample"]["inchikey"]) {
      disable_tab(
        all_contexts[i].tab_index,
        "green",
        "This compound has already been sent to peakforest"
      )
    }
  }
  if (already_sent_data[index] == null) {
    already_sent_data[index] = [] ;
  }
  json.forEach((id) => {
    already_sent_data[index].push(id)
    $("#send_buttons_div").prepend(`
    <div class="row">
      <div class="col-lg-3">
        <div class="alert alert-success alert-dismissible" role="alert">
          <button type="button" class="close" data-dismiss="alert">
            <span aria-hidden="true">×</span>
            <span class="sr-only">
              <spring:message code="alert.close" text="Close"></spring:message>
            </span>
          </button>
          <strong>
            <spring:message code="alert.strong.info" text="Success!"></spring:message>
          </strong> Spectrum has been sent:
          <a
            href="${ctx().peakforest_url}/webapp/home?PFs=${id.slice(3)}"
            target="_blank"
          >${id}</a>
        </div>
      </div>
    </div>`)
  })
}

function failed_send_to_pf(err, bundle) {
  console.log(err) ;
  $("#send_buttons_div").prepend(`
  <div class="row">
    <div class="col-lg-3">
      <div class="alert alert-error alert-dismissible" role="alert">
        <button type="button" class="close" data-dismiss="alert">
          <span aria-hidden="true">×</span>
          <span class="sr-only">
            <spring:message code="alert.close" text="Close"></spring:message>
          </span>
        </button>
        <strong>
          <spring:message code="alert.strong.info" text="Error!"></spring:message>
        </strong> Spectrum has not been sent!
      </div>
    </div>
  </div>`)
}

function already_sent(bundle, index) {
  return already_sent_data[index] != null ;
}

function failed_already_sent(bundle, index) {
  already_sent_data[index].forEach((id) => {
    $("#send_buttons_div").prepend(`
    <div class="row">
      <div class="col-lg-3">
        <div class="alert alert-warning alert-dismissible" role="alert">
          <button type="button" class="close" data-dismiss="alert">
            <span aria-hidden="true">×</span>
            <span class="sr-only">
              <spring:message code="alert.close" text="Close"></spring:message>
            </span>
          </button>
          <strong>
            <spring:message code="alert.strong.info" text="warning!"></spring:message>
          </strong> Spectrum has already been sent:
          <a
            href="${ctx().peakforest_url}/webapp/home?PFs=${id.slice(3)}"
            target="_blank"
          >${id}</a>
        </div>
      </div>
    </div>`)
  }) ;
}

function send_everything_to_peakforest(url, token) {
  var bundles ;
  if (context.is_mix()) {
    bundles = [all_mix_data] ;
  } else {
    bundles = create_dataset_bundles() ;
  }
  bundles.forEach((bundle, index) => {
    if (already_sent(bundle, index)) {
      return failed_already_sent(bundle, index) ;
    }
    console.log(bundle)
    $.ajax({
      type: "post",
      url: `${url}/rest/v2/spectrum?token=${token}`,
      data: JSON.stringify(bundle),
      contentType: "application/json",
      success: function(json) {
        successfull_send_to_pf(bundle, json, index)
      }, error: function(err) {
        failed_send_to_pf(err, bundle)
      }
    })
    $.ajax({
      type: "post",
      url: "/",
      data: `{"index": ${index}, "object": ${JSON.stringify(bundle)}}`,
      contentType: "application/json",
      error: function(err) {
        console.log(`Error: JSON will not be produced by the application.`)
      }
    })
  })
  // console.log(bundles)
}

function create_dataset_bundles() {
  var bundles = [] ;
  var data ;
  all_contexts.forEach((context, index) => {
    if ((data = context.sent_json) === null) {
      return ;
    }
    if (bundles.length === 0) {
      // console.log("First metadata!")
      return bundles.push(data) ;
    }
    if (merge_in_bundle(bundles, data)) {
      // console.log("Merged!")
    } else {
      // console.log("New metadata!")
    }
  }) ;
  return bundles ;
}

function merge_in_bundle(bundles, data) {
  for(var i = 0 ; i < bundles.length ; i += 1) {
    if (
      identical(bundles[i]["sample"], data["sample"])
      && identical(bundles[i]["chromatography"], data["chromatography"])
      && identical(bundles[i]["analyzer"], data["analyzer"])
      && identical(bundles[i]["ionization_mode_positive"], data["ionization_mode_positive"])
      && identical(bundles[i]["ionization_mode_negative"], data["ionization_mode_negative"])
      && identical(bundles[i]["other_metadata"], data["other_metadata"])
    ) {
      bundles[i]["peaklists"].push(data["peaklists"][0]) ;
      return true ;
    } else {
      continue ;
      console.log(
        "sample: "
        + identical(bundles[i]["sample"], data["sample"])
      )
      console.log(
        "chromatography: "
        + identical(bundles[i]["chromatography"], data["chromatography"])
      )
      console.log(
        "analyzer: "
        + identical(bundles[i]["analyzer"], data["analyzer"])
      )
      console.log(
        "ionization_mode_positive: "
        + identical(bundles[i]["ionization_mode_positive"], data["ionization_mode_positive"])
      )
      console.log(
        "ionization_mode_negative: "
        + identical(bundles[i]["ionization_mode_negative"], data["ionization_mode_negative"])
      )
      console.log(
        "other_metadata: "
        + identical(bundles[i]["other_metadata"], data["other_metadata"])
      )
    }
  }
  bundles.push(data) ;
  return false ;
}

function identical(left, right) {
  if (typeof left !== typeof right) {
    return false ;
  }
  if (left === null) {
    return right === null ;
  }
  if (right === null) {
    return left === null ;
  }
  switch (typeof left) {
    case "array":
      return identical_array(left, right) ;
      break ;
    case "object":
      return identical_object(left, right) ;
      break ;
    default:
      break ;
  }
  return (left === right)
}

function identical_array(left, right) {
  if (right.length !== left.length) {
    return false ;
  }
  for(var i = 0 ; i < left.length ; i += 1) {
    if (!identical(left[i], right[i])) {
      return false ;
    }
  }
  return true ;
}

function identical_object(left, right) {
  var left_keys ;

  if (!(
    share_keys(left, right)
    && share_keys(right, left)
  )) {
    return true ;
  }
  left_keys = Object.keys(left) ;
  for (var i = 0 ; i < left_keys.length ; i += 1){
    if (!identical(left[left_keys[i]], right[left_keys[i]])) {
      return false ;
    }
  }
  return true ;
}

function share_keys(left, right) {
  var left_keys ;
  var right_keys ;

  left_keys = Object.keys(left) ;
  right_keys = Object.keys(right) ;
  for(var i = 0 ; i < left_keys.length ; i += 1) {
    if (!right_keys.includes(left_keys[i])) {
      return false ;
    }
  }
  return true ;
}

var set_inchi_data = function(data, tab_index) {
  inchidata[data.inchikey] = data ;
  $(`#add1spectrum-sample-inchi-${tab_index}`).val(data.inchi);
  $(`#add1spectrum-sample-inchi-${tab_index}`).change();
  $(`#add1spectrum-sample-commonName-${tab_index}`).val(data.name);
  $(`#add1spectrum-sample-commonName-${tab_index}`).change();
  $(`#sample-bonus-display-${tab_index}`).html(
    `<img
      class=""
      src="{{ PF_URL_PLACEHOLDER }}/webapp/image/${data.type}/${data.inchikey}"
      alt="${data.name}"
    >`
  );
}

var lightgrayRenderer = function(instance, td, row, col, prop, value, cellProperties) {
  Handsontable.renderers.TextRenderer.apply(this, arguments);
  td.style.backgroundColor = "#EEE";
}
