## natural-cubic-spline interpolation
## usage: yspline = spline(x,y,xspline)
## example: 
##	x = 0:10; y = sin(x);
##	xspline = 0:0.1:10; yspline = spline(x,y,xspline);
##	##plot(x,y,"+",xspline,yspline);
## Given the vectors x and y, which tabulate a function, with 
## x(1) < x(2) < x(3) <... or x(1) > x(2) > x(3) >..., and given
## the vector xspline, this function returns a natural-cubic-spline 
## interpolated vector yspline. 
## author: Zdenek Remes, May 22, 1999


function ynew = spline(x,y,xnew)
[x,index]=sort(x);
y=y(index);
n=length(y);
y2(1)=0.0;
y2(n)=0.0;
u(1)=0.0;
for i=2:n-1
  sig=(x(i)-x(i-1))/(x(i+1)-x(i-1));
  p=sig*y2(i-1)+2.0;
  y2(i)=(sig-1.0)/p;
  u(i)=(y(i+1)-y(i))/(x(i+1)-x(i))-(y(i)-y(i-1))/(x(i)-x(i-1));
  u(i)=(6.0*u(i)/(x(i+1)-x(i-1))-sig*u(i-1))/p;
endfor;
k=n-1;
while (k >= 1)
  y2(k)=y2(k)*y2(k+1)+u(k);
  k--;
endwhile;

i1=1; in=length(xnew);

#if (xnew(1) < x(1)) 
#  error("spline: bad xspline");
#endif;
#if (xnew(in) > x(n)) 
#  error("spline: bad xspline");
#endif;
  
if (xnew(1) == x(1)) 
  ynew(1)=y(1);
  i1=2;
endif;
if (xnew(in) == x(n)) 
  ynew(in)=y(n);
  in=in-1; 
endif;
  

for i=i1:in  
  khi=n;
  klo=1;
  while ((khi-klo) > 1)
    k=floor((khi+klo)/2);
    if (x(k) > xnew(i)) 
      khi=k;
    else
      klo=k;  
    endif;
  endwhile;
  h=x(khi)-x(klo);
  a=(x(khi)-xnew(i))/h;
  b=(xnew(i)-x(klo))/h;
  ynew(i)=a*y(klo)+b*y(khi)+((a^3-a)*y2(klo)+(b^3-b)*y2(khi))*(h*h)/6.0;
endfor;
endfunction;

## Savitzky-Golay smoothing filter
## usage: [xsavgol,ysavgol]=savgol(x,y,nl,nr,m)
## example: x=0:0.01:3;y1=sin(x.^3);y=y1+(rand(1,301)-0.5)/3;
##	    [xsavgol,ysavgol]=savgol(x,y,10,10,2);
##	    ##plot(x,y,"+",xsavgol,ysavgol,x,y1)
## Given vectors x, y containing a tabulated data y=f(x) with 
## equally spaced x's this function calculates smoothed data
## ysavgol=g(xsavgol) by Savitzky-Golay smoothing filter.
## nl is the number of leftward (past) data points used, while
## nr is the number of rightward (future) data points, making
## the total number of data points used nl+nr+1. m is the order
## of the smoothing polynomial, also equal to the highest
## conserved moment; usual values are m=2 or m=4.
## The idea of Savitzky-Golay filtering is to smooth the
## underlying data y=f(x) within the moving window not by a
## constant (whose estimate is the average), but by a poly-
## nomial of higher order. Thus for a point y(i) the function
## savgol fits by a least-squares method a polynomial to
## points y(i-nl), ..., y(i+nr) in the moving window, and
## then set g(i-nl+1) to the value of that polynomial at
## position x(i). 
## Zdenek Remes, Mai 22, 1999
	
function [xnew,ynew]=savgol(x,y,nl, nr, M)

    if max(diff(x,2))>100*eps 
	error("The x's must be equally spaced.")
    endif
    for i=-nl:nr
	for j=0:M
	    A(i+nl+1,j+1)=i^j;
	endfor
    endfor
    AA=inv(A'*A);
    for i=-nl:nr
	cc=0;
	for m=0:M
	    cc=cc+AA(1,m+1)*i^m;
	endfor
    c(i+nl+1)=cc;
    endfor
    
    nx=length(x);
    for i=nl:nx-nr-1
	yy=0;
	for j=-nl:nr
	    yy=yy+c(j+nl+1)*y(i+j+1);
	endfor
        xnew(i-nl+1)=x(i+1);
	ynew(i-nl+1)=yy;
    endfor    
endfunction

## x=0:0.01:3;
## y1=sin(x.^3);
## y=y1+(rand(1,301)-0.5)/3;
## [xsavgol,ysavgol]=savgol(x,y,10,10,2);
## plot(x,y,"+",xsavgol,ysavgol,x,y1);
## pause;
zero=[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ];
##load -force CPNA.dat;
##[xs,ys]=savgol(x,y,5,5,4);
##save -ascii CPNA.sm xs ys;

load -force CFBr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFBr.sm xs ys;
printf("CFBr.sm\n");
load -force CFC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFC0.sm xs ys;
printf("CFC0.sm\n");
load -force CFC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFC3.sm xs ys;
printf("CFC3.sm\n");
load -force CFCF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFCF.sm xs ys;
printf("CFCF.sm\n");
load -force CFCL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFCL.sm xs ys;
printf("CFCL.sm\n");
load -force CFCN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFCN.sm xs ys;
printf("CFCN.sm\n");
load -force CFCO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFCO.sm xs ys;
printf("CFCO.sm\n");
load -force CFCP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFCP.sm xs ys;
printf("CFCP.sm\n");
load -force CFCW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFCW.sm xs ys;
printf("CFCW.sm\n");
load -force CFF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFF_.sm xs ys;
printf("CFF_.sm\n");
load -force CFFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFFe.sm xs ys;
printf("CFFe.sm\n");
load -force CFHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFHL.sm xs ys;
printf("CFHL.sm\n");
load -force CFMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFMg.sm xs ys;
printf("CFMg.sm\n");
load -force CFMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFMn.sm xs ys;
printf("CFMn.sm\n");
load -force CFN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFN0.sm xs ys;
printf("CFN0.sm\n");
load -force CFNA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFNA.sm xs ys;
printf("CFNA.sm\n");
load -force CFNC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFNC.sm xs ys;
printf("CFNC.sm\n");
load -force CFND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFND.sm xs ys;
printf("CFND.sm\n");
load -force CFNP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFNP.sm xs ys;
printf("CFNP.sm\n");
load -force CFNR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFNR.sm xs ys;
printf("CFNR.sm\n");
load -force CFNS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFNS.sm xs ys;
printf("CFNS.sm\n");
load -force CFOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFOA.sm xs ys;
printf("CFOA.sm\n");
load -force CFOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFOC.sm xs ys;
printf("CFOC.sm\n");
load -force CFOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFOD.sm xs ys;
printf("CFOD.sm\n");
load -force CFOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFOE.sm xs ys;
printf("CFOE.sm\n");
load -force CFOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFOR.sm xs ys;
printf("CFOR.sm\n");
load -force CFOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFOS.sm xs ys;
printf("CFOS.sm\n");
load -force CFP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFP_.sm xs ys;
printf("CFP_.sm\n");
load -force CFSA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFSA.sm xs ys;
printf("CFSA.sm\n");
load -force CFSD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFSD.sm xs ys;
printf("CFSD.sm\n");
load -force CFV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFV_.sm xs ys;
printf("CFV_.sm\n");
load -force CFZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFZn.sm xs ys;
printf("CFZn.sm\n");
load -force CFcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFcF.sm xs ys;
printf("CFcF.sm\n");
load -force CFcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CFcP.sm xs ys;
printf("CFcP.sm\n");
load -force CNBr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNBr.sm xs ys;
printf("CNBr.sm\n");
load -force CNC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNC0.sm xs ys;
printf("CNC0.sm\n");
load -force CNC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNC3.sm xs ys;
printf("CNC3.sm\n");
load -force CNCF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNCF.sm xs ys;
printf("CNCF.sm\n");
load -force CNCL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNCL.sm xs ys;
printf("CNCL.sm\n");
load -force CNCN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNCN.sm xs ys;
printf("CNCN.sm\n");
load -force CNCO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNCO.sm xs ys;
printf("CNCO.sm\n");
load -force CNCP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNCP.sm xs ys;
printf("CNCP.sm\n");
load -force CNCW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNCW.sm xs ys;
printf("CNCW.sm\n");
load -force CNF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNF_.sm xs ys;
printf("CNF_.sm\n");
load -force CNFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNFe.sm xs ys;
printf("CNFe.sm\n");
load -force CNHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNHL.sm xs ys;
printf("CNHL.sm\n");
load -force CNMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNMg.sm xs ys;
printf("CNMg.sm\n");
load -force CNMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNMn.sm xs ys;
printf("CNMn.sm\n");
load -force CNN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNN0.sm xs ys;
printf("CNN0.sm\n");
load -force CNNA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNNA.sm xs ys;
printf("CNNA.sm\n");
load -force CNNC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNNC.sm xs ys;
printf("CNNC.sm\n");
load -force CNND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNND.sm xs ys;
printf("CNND.sm\n");
load -force CNNP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNNP.sm xs ys;
printf("CNNP.sm\n");
load -force CNNR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNNR.sm xs ys;
printf("CNNR.sm\n");
load -force CNNS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNNS.sm xs ys;
printf("CNNS.sm\n");
load -force CNOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNOA.sm xs ys;
printf("CNOA.sm\n");
load -force CNOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNOC.sm xs ys;
printf("CNOC.sm\n");
load -force CNOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNOD.sm xs ys;
printf("CNOD.sm\n");
load -force CNOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNOE.sm xs ys;
printf("CNOE.sm\n");
load -force CNOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNOR.sm xs ys;
printf("CNOR.sm\n");
load -force CNOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNOS.sm xs ys;
printf("CNOS.sm\n");
load -force CNP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNP_.sm xs ys;
printf("CNP_.sm\n");
load -force CNSA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNSA.sm xs ys;
printf("CNSA.sm\n");
load -force CNSD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNSD.sm xs ys;
printf("CNSD.sm\n");
load -force CNV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNV_.sm xs ys;
printf("CNV_.sm\n");
load -force CNZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNZn.sm xs ys;
printf("CNZn.sm\n");
load -force CNcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNcF.sm xs ys;
printf("CNcF.sm\n");
load -force CNcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CNcP.sm xs ys;
printf("CNcP.sm\n");
load -force COBr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COBr.sm xs ys;
printf("COBr.sm\n");
load -force COC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COC0.sm xs ys;
printf("COC0.sm\n");
load -force COC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COC3.sm xs ys;
printf("COC3.sm\n");
load -force COCF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COCF.sm xs ys;
printf("COCF.sm\n");
load -force COCL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COCL.sm xs ys;
printf("COCL.sm\n");
load -force COCN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COCN.sm xs ys;
printf("COCN.sm\n");
load -force COCO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COCO.sm xs ys;
printf("COCO.sm\n");
load -force COCP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COCP.sm xs ys;
printf("COCP.sm\n");
load -force COCW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COCW.sm xs ys;
printf("COCW.sm\n");
load -force COF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COF_.sm xs ys;
printf("COF_.sm\n");
load -force COFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COFe.sm xs ys;
printf("COFe.sm\n");
load -force COHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COHL.sm xs ys;
printf("COHL.sm\n");
load -force COMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COMg.sm xs ys;
printf("COMg.sm\n");
load -force COMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COMn.sm xs ys;
printf("COMn.sm\n");
load -force CON0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CON0.sm xs ys;
printf("CON0.sm\n");
load -force CONA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CONA.sm xs ys;
printf("CONA.sm\n");
load -force CONC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CONC.sm xs ys;
printf("CONC.sm\n");
load -force COND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COND.sm xs ys;
printf("COND.sm\n");
load -force CONP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CONP.sm xs ys;
printf("CONP.sm\n");
load -force CONR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CONR.sm xs ys;
printf("CONR.sm\n");
load -force CONS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CONS.sm xs ys;
printf("CONS.sm\n");
load -force COOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COOA.sm xs ys;
printf("COOA.sm\n");
load -force COOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COOC.sm xs ys;
printf("COOC.sm\n");
load -force COOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COOD.sm xs ys;
printf("COOD.sm\n");
load -force COOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COOE.sm xs ys;
printf("COOE.sm\n");
load -force COOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COOR.sm xs ys;
printf("COOR.sm\n");
load -force COOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COOS.sm xs ys;
printf("COOS.sm\n");
load -force COP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COP_.sm xs ys;
printf("COP_.sm\n");
load -force COSA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COSA.sm xs ys;
printf("COSA.sm\n");
load -force COSD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COSD.sm xs ys;
printf("COSD.sm\n");
load -force COV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COV_.sm xs ys;
printf("COV_.sm\n");
load -force COZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COZn.sm xs ys;
printf("COZn.sm\n");
load -force COcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COcF.sm xs ys;
printf("COcF.sm\n");
load -force COcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii COcP.sm xs ys;
printf("COcP.sm\n");
load -force CPBr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPBr.sm xs ys;
printf("CPBr.sm\n");
load -force CPC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPC0.sm xs ys;
printf("CPC0.sm\n");
load -force CPC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPC3.sm xs ys;
printf("CPC3.sm\n");
load -force CPCF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPCF.sm xs ys;
printf("CPCF.sm\n");
load -force CPCL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPCL.sm xs ys;
printf("CPCL.sm\n");
load -force CPCN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPCN.sm xs ys;
printf("CPCN.sm\n");
load -force CPCO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPCO.sm xs ys;
printf("CPCO.sm\n");
load -force CPCP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPCP.sm xs ys;
printf("CPCP.sm\n");
load -force CPCW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPCW.sm xs ys;
printf("CPCW.sm\n");
load -force CPF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPF_.sm xs ys;
printf("CPF_.sm\n");
load -force CPFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPFe.sm xs ys;
printf("CPFe.sm\n");
load -force CPHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPHL.sm xs ys;
printf("CPHL.sm\n");
load -force CPMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPMg.sm xs ys;
printf("CPMg.sm\n");
load -force CPMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPMn.sm xs ys;
printf("CPMn.sm\n");
load -force CPN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPN0.sm xs ys;
printf("CPN0.sm\n");
load -force CPNA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPNA.sm xs ys;
printf("CPNA.sm\n");
load -force CPNC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPNC.sm xs ys;
printf("CPNC.sm\n");
load -force CPND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPND.sm xs ys;
printf("CPND.sm\n");
load -force CPNP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPNP.sm xs ys;
printf("CPNP.sm\n");
load -force CPNR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPNR.sm xs ys;
printf("CPNR.sm\n");
load -force CPNS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPNS.sm xs ys;
printf("CPNS.sm\n");
load -force CPOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPOA.sm xs ys;
printf("CPOA.sm\n");
load -force CPOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPOC.sm xs ys;
printf("CPOC.sm\n");
load -force CPOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPOD.sm xs ys;
printf("CPOD.sm\n");
load -force CPOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPOE.sm xs ys;
printf("CPOE.sm\n");
load -force CPOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPOR.sm xs ys;
printf("CPOR.sm\n");
load -force CPOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPOS.sm xs ys;
printf("CPOS.sm\n");
load -force CPP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPP_.sm xs ys;
printf("CPP_.sm\n");
load -force CPSA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPSA.sm xs ys;
printf("CPSA.sm\n");
load -force CPSD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPSD.sm xs ys;
printf("CPSD.sm\n");
load -force CPV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPV_.sm xs ys;
printf("CPV_.sm\n");
load -force CPZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPZn.sm xs ys;
printf("CPZn.sm\n");
load -force CPcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPcF.sm xs ys;
printf("CPcF.sm\n");
load -force CPcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii CPcP.sm xs ys;
printf("CPcP.sm\n");
load -force HHBr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHBr.sm xs ys;
printf("HHBr.sm\n");
load -force HHC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHC0.sm xs ys;
printf("HHC0.sm\n");
load -force HHC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHC3.sm xs ys;
printf("HHC3.sm\n");
load -force HHCF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHCF.sm xs ys;
printf("HHCF.sm\n");
load -force HHCL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHCL.sm xs ys;
printf("HHCL.sm\n");
load -force HHCN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHCN.sm xs ys;
printf("HHCN.sm\n");
load -force HHCO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHCO.sm xs ys;
printf("HHCO.sm\n");
load -force HHCP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHCP.sm xs ys;
printf("HHCP.sm\n");
load -force HHCW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHCW.sm xs ys;
printf("HHCW.sm\n");
load -force HHF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHF_.sm xs ys;
printf("HHF_.sm\n");
load -force HHFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHFe.sm xs ys;
printf("HHFe.sm\n");
load -force HHHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHHL.sm xs ys;
printf("HHHL.sm\n");
load -force HHMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHMg.sm xs ys;
printf("HHMg.sm\n");
load -force HHMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHMn.sm xs ys;
printf("HHMn.sm\n");
load -force HHN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHN0.sm xs ys;
printf("HHN0.sm\n");
load -force HHNA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHNA.sm xs ys;
printf("HHNA.sm\n");
load -force HHNC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHNC.sm xs ys;
printf("HHNC.sm\n");
load -force HHND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHND.sm xs ys;
printf("HHND.sm\n");
load -force HHNP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHNP.sm xs ys;
printf("HHNP.sm\n");
load -force HHNR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHNR.sm xs ys;
printf("HHNR.sm\n");
load -force HHNS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHNS.sm xs ys;
printf("HHNS.sm\n");
load -force HHOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHOA.sm xs ys;
printf("HHOA.sm\n");
load -force HHOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHOC.sm xs ys;
printf("HHOC.sm\n");
load -force HHOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHOD.sm xs ys;
printf("HHOD.sm\n");
load -force HHOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHOE.sm xs ys;
printf("HHOE.sm\n");
load -force HHOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHOR.sm xs ys;
printf("HHOR.sm\n");
load -force HHOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHOS.sm xs ys;
printf("HHOS.sm\n");
load -force HHP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHP_.sm xs ys;
printf("HHP_.sm\n");
load -force HHSA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHSA.sm xs ys;
printf("HHSA.sm\n");
load -force HHSD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHSD.sm xs ys;
printf("HHSD.sm\n");
load -force HHV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHV_.sm xs ys;
printf("HHV_.sm\n");
load -force HHZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHZn.sm xs ys;
printf("HHZn.sm\n");
load -force HHcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHcF.sm xs ys;
printf("HHcF.sm\n");
load -force HHcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii HHcP.sm xs ys;
printf("HHcP.sm\n");
load -force NCBr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCBr.sm xs ys;
printf("NCBr.sm\n");
load -force NCC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCC0.sm xs ys;
printf("NCC0.sm\n");
load -force NCC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCC3.sm xs ys;
printf("NCC3.sm\n");
load -force NCCF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCCF.sm xs ys;
printf("NCCF.sm\n");
load -force NCCL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCCL.sm xs ys;
printf("NCCL.sm\n");
load -force NCCN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCCN.sm xs ys;
printf("NCCN.sm\n");
load -force NCCO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCCO.sm xs ys;
printf("NCCO.sm\n");
load -force NCCP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCCP.sm xs ys;
printf("NCCP.sm\n");
load -force NCCW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCCW.sm xs ys;
printf("NCCW.sm\n");
load -force NCF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCF_.sm xs ys;
printf("NCF_.sm\n");
load -force NCFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCFe.sm xs ys;
printf("NCFe.sm\n");
load -force NCHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCHL.sm xs ys;
printf("NCHL.sm\n");
load -force NCMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCMg.sm xs ys;
printf("NCMg.sm\n");
load -force NCMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCMn.sm xs ys;
printf("NCMn.sm\n");
load -force NCN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCN0.sm xs ys;
printf("NCN0.sm\n");
load -force NCNA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCNA.sm xs ys;
printf("NCNA.sm\n");
load -force NCNC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCNC.sm xs ys;
printf("NCNC.sm\n");
load -force NCND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCND.sm xs ys;
printf("NCND.sm\n");
load -force NCNP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCNP.sm xs ys;
printf("NCNP.sm\n");
load -force NCNR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCNR.sm xs ys;
printf("NCNR.sm\n");
load -force NCNS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCNS.sm xs ys;
printf("NCNS.sm\n");
load -force NCOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCOA.sm xs ys;
printf("NCOA.sm\n");
load -force NCOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCOC.sm xs ys;
printf("NCOC.sm\n");
load -force NCOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCOD.sm xs ys;
printf("NCOD.sm\n");
load -force NCOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCOE.sm xs ys;
printf("NCOE.sm\n");
load -force NCOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCOR.sm xs ys;
printf("NCOR.sm\n");
load -force NCOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCOS.sm xs ys;
printf("NCOS.sm\n");
load -force NCP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCP_.sm xs ys;
printf("NCP_.sm\n");
load -force NCSA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCSA.sm xs ys;
printf("NCSA.sm\n");
load -force NCSD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCSD.sm xs ys;
printf("NCSD.sm\n");
load -force NCV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCV_.sm xs ys;
printf("NCV_.sm\n");
load -force NCZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCZn.sm xs ys;
printf("NCZn.sm\n");
load -force NCcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCcF.sm xs ys;
printf("NCcF.sm\n");
load -force NCcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NCcP.sm xs ys;
printf("NCcP.sm\n");
load -force NDBr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDBr.sm xs ys;
printf("NDBr.sm\n");
load -force NDC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDC0.sm xs ys;
printf("NDC0.sm\n");
load -force NDC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDC3.sm xs ys;
printf("NDC3.sm\n");
load -force NDCF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDCF.sm xs ys;
printf("NDCF.sm\n");
load -force NDCL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDCL.sm xs ys;
printf("NDCL.sm\n");
load -force NDCN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDCN.sm xs ys;
printf("NDCN.sm\n");
load -force NDCO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDCO.sm xs ys;
printf("NDCO.sm\n");
load -force NDCP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDCP.sm xs ys;
printf("NDCP.sm\n");
load -force NDCW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDCW.sm xs ys;
printf("NDCW.sm\n");
load -force NDF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDF_.sm xs ys;
printf("NDF_.sm\n");
load -force NDFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDFe.sm xs ys;
printf("NDFe.sm\n");
load -force NDHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDHL.sm xs ys;
printf("NDHL.sm\n");
load -force NDMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDMg.sm xs ys;
printf("NDMg.sm\n");
load -force NDMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDMn.sm xs ys;
printf("NDMn.sm\n");
load -force NDN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDN0.sm xs ys;
printf("NDN0.sm\n");
load -force NDNA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDNA.sm xs ys;
printf("NDNA.sm\n");
load -force NDNC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDNC.sm xs ys;
printf("NDNC.sm\n");
load -force NDND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDND.sm xs ys;
printf("NDND.sm\n");
load -force NDNP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDNP.sm xs ys;
printf("NDNP.sm\n");
load -force NDNR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDNR.sm xs ys;
printf("NDNR.sm\n");
load -force NDNS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDNS.sm xs ys;
printf("NDNS.sm\n");
load -force NDOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDOA.sm xs ys;
printf("NDOA.sm\n");
load -force NDOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDOC.sm xs ys;
printf("NDOC.sm\n");
load -force NDOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDOD.sm xs ys;
printf("NDOD.sm\n");
load -force NDOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDOE.sm xs ys;
printf("NDOE.sm\n");
load -force NDOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDOR.sm xs ys;
printf("NDOR.sm\n");
load -force NDOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDOS.sm xs ys;
printf("NDOS.sm\n");
load -force NDP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDP_.sm xs ys;
printf("NDP_.sm\n");
load -force NDSA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDSA.sm xs ys;
printf("NDSA.sm\n");
load -force NDSD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDSD.sm xs ys;
printf("NDSD.sm\n");
load -force NDV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDV_.sm xs ys;
printf("NDV_.sm\n");
load -force NDZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDZn.sm xs ys;
printf("NDZn.sm\n");
load -force NDcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDcF.sm xs ys;
printf("NDcF.sm\n");
load -force NDcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NDcP.sm xs ys;
printf("NDcP.sm\n");
load -force NRBr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRBr.sm xs ys;
printf("NRBr.sm\n");
load -force NRC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRC0.sm xs ys;
printf("NRC0.sm\n");
load -force NRC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRC3.sm xs ys;
printf("NRC3.sm\n");
load -force NRCF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRCF.sm xs ys;
printf("NRCF.sm\n");
load -force NRCL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRCL.sm xs ys;
printf("NRCL.sm\n");
load -force NRCN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRCN.sm xs ys;
printf("NRCN.sm\n");
load -force NRCO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRCO.sm xs ys;
printf("NRCO.sm\n");
load -force NRCP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRCP.sm xs ys;
printf("NRCP.sm\n");
load -force NRCW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRCW.sm xs ys;
printf("NRCW.sm\n");
load -force NRF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRF_.sm xs ys;
printf("NRF_.sm\n");
load -force NRFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRFe.sm xs ys;
printf("NRFe.sm\n");
load -force NRHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRHL.sm xs ys;
printf("NRHL.sm\n");
load -force NRMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRMg.sm xs ys;
printf("NRMg.sm\n");
load -force NRMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRMn.sm xs ys;
printf("NRMn.sm\n");
load -force NRN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRN0.sm xs ys;
printf("NRN0.sm\n");
load -force NRNA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRNA.sm xs ys;
printf("NRNA.sm\n");
load -force NRNC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRNC.sm xs ys;
printf("NRNC.sm\n");
load -force NRND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRND.sm xs ys;
printf("NRND.sm\n");
load -force NRNP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRNP.sm xs ys;
printf("NRNP.sm\n");
load -force NRNR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRNR.sm xs ys;
printf("NRNR.sm\n");
load -force NRNS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRNS.sm xs ys;
printf("NRNS.sm\n");
load -force NROA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NROA.sm xs ys;
printf("NROA.sm\n");
load -force NROC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NROC.sm xs ys;
printf("NROC.sm\n");
load -force NROD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NROD.sm xs ys;
printf("NROD.sm\n");
load -force NROE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NROE.sm xs ys;
printf("NROE.sm\n");
load -force NROR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NROR.sm xs ys;
printf("NROR.sm\n");
load -force NROS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NROS.sm xs ys;
printf("NROS.sm\n");
load -force NRP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRP_.sm xs ys;
printf("NRP_.sm\n");
load -force NRSA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRSA.sm xs ys;
printf("NRSA.sm\n");
load -force NRSD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRSD.sm xs ys;
printf("NRSD.sm\n");
load -force NRV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRV_.sm xs ys;
printf("NRV_.sm\n");
load -force NRZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRZn.sm xs ys;
printf("NRZn.sm\n");
load -force NRcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRcF.sm xs ys;
printf("NRcF.sm\n");
load -force NRcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii NRcP.sm xs ys;
printf("NRcP.sm\n");
load -force OABr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OABr.sm xs ys;
printf("OABr.sm\n");
load -force OAC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAC0.sm xs ys;
printf("OAC0.sm\n");
load -force OAC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAC3.sm xs ys;
printf("OAC3.sm\n");
load -force OACF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OACF.sm xs ys;
printf("OACF.sm\n");
load -force OACL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OACL.sm xs ys;
printf("OACL.sm\n");
load -force OACN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OACN.sm xs ys;
printf("OACN.sm\n");
load -force OACO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OACO.sm xs ys;
printf("OACO.sm\n");
load -force OACP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OACP.sm xs ys;
printf("OACP.sm\n");
load -force OACW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OACW.sm xs ys;
printf("OACW.sm\n");
load -force OAF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAF_.sm xs ys;
printf("OAF_.sm\n");
load -force OAFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAFe.sm xs ys;
printf("OAFe.sm\n");
load -force OAHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAHL.sm xs ys;
printf("OAHL.sm\n");
load -force OAMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAMg.sm xs ys;
printf("OAMg.sm\n");
load -force OAMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAMn.sm xs ys;
printf("OAMn.sm\n");
load -force OAN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAN0.sm xs ys;
printf("OAN0.sm\n");
load -force OANA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OANA.sm xs ys;
printf("OANA.sm\n");
load -force OANC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OANC.sm xs ys;
printf("OANC.sm\n");
load -force OAND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAND.sm xs ys;
printf("OAND.sm\n");
load -force OANP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OANP.sm xs ys;
printf("OANP.sm\n");
load -force OANR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OANR.sm xs ys;
printf("OANR.sm\n");
load -force OANS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OANS.sm xs ys;
printf("OANS.sm\n");
load -force OAOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAOA.sm xs ys;
printf("OAOA.sm\n");
load -force OAOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAOC.sm xs ys;
printf("OAOC.sm\n");
load -force OAOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAOD.sm xs ys;
printf("OAOD.sm\n");
load -force OAOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAOE.sm xs ys;
printf("OAOE.sm\n");
load -force OAOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAOR.sm xs ys;
printf("OAOR.sm\n");
load -force OAOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAOS.sm xs ys;
printf("OAOS.sm\n");
load -force OAP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAP_.sm xs ys;
printf("OAP_.sm\n");
load -force OASA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OASA.sm xs ys;
printf("OASA.sm\n");
load -force OASD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OASD.sm xs ys;
printf("OASD.sm\n");
load -force OAV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAV_.sm xs ys;
printf("OAV_.sm\n");
load -force OAZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAZn.sm xs ys;
printf("OAZn.sm\n");
load -force OAcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAcF.sm xs ys;
printf("OAcF.sm\n");
load -force OAcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OAcP.sm xs ys;
printf("OAcP.sm\n");
load -force OCBr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCBr.sm xs ys;
printf("OCBr.sm\n");
load -force OCC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCC0.sm xs ys;
printf("OCC0.sm\n");
load -force OCC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCC3.sm xs ys;
printf("OCC3.sm\n");
load -force OCCF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCCF.sm xs ys;
printf("OCCF.sm\n");
load -force OCCL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCCL.sm xs ys;
printf("OCCL.sm\n");
load -force OCCN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCCN.sm xs ys;
printf("OCCN.sm\n");
load -force OCCO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCCO.sm xs ys;
printf("OCCO.sm\n");
load -force OCCP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCCP.sm xs ys;
printf("OCCP.sm\n");
load -force OCCW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCCW.sm xs ys;
printf("OCCW.sm\n");
load -force OCF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCF_.sm xs ys;
printf("OCF_.sm\n");
load -force OCFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCFe.sm xs ys;
printf("OCFe.sm\n");
load -force OCHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCHL.sm xs ys;
printf("OCHL.sm\n");
load -force OCMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCMg.sm xs ys;
printf("OCMg.sm\n");
load -force OCMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCMn.sm xs ys;
printf("OCMn.sm\n");
load -force OCN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCN0.sm xs ys;
printf("OCN0.sm\n");
load -force OCNA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCNA.sm xs ys;
printf("OCNA.sm\n");
load -force OCNC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCNC.sm xs ys;
printf("OCNC.sm\n");
load -force OCND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCND.sm xs ys;
printf("OCND.sm\n");
load -force OCNP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCNP.sm xs ys;
printf("OCNP.sm\n");
load -force OCNR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCNR.sm xs ys;
printf("OCNR.sm\n");
load -force OCNS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCNS.sm xs ys;
printf("OCNS.sm\n");
load -force OCOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCOA.sm xs ys;
printf("OCOA.sm\n");
load -force OCOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCOC.sm xs ys;
printf("OCOC.sm\n");
load -force OCOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCOD.sm xs ys;
printf("OCOD.sm\n");
load -force OCOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCOE.sm xs ys;
printf("OCOE.sm\n");
load -force OCOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCOR.sm xs ys;
printf("OCOR.sm\n");
load -force OCOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCOS.sm xs ys;
printf("OCOS.sm\n");
load -force OCP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCP_.sm xs ys;
printf("OCP_.sm\n");
load -force OCSA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCSA.sm xs ys;
printf("OCSA.sm\n");
load -force OCSD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCSD.sm xs ys;
printf("OCSD.sm\n");
load -force OCV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCV_.sm xs ys;
printf("OCV_.sm\n");
load -force OCZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCZn.sm xs ys;
printf("OCZn.sm\n");
load -force OCcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCcF.sm xs ys;
printf("OCcF.sm\n");
load -force OCcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OCcP.sm xs ys;
printf("OCcP.sm\n");
load -force ODBr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODBr.sm xs ys;
printf("ODBr.sm\n");
load -force ODC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODC0.sm xs ys;
printf("ODC0.sm\n");
load -force ODC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODC3.sm xs ys;
printf("ODC3.sm\n");
load -force ODCF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODCF.sm xs ys;
printf("ODCF.sm\n");
load -force ODCL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODCL.sm xs ys;
printf("ODCL.sm\n");
load -force ODCN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODCN.sm xs ys;
printf("ODCN.sm\n");
load -force ODCO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODCO.sm xs ys;
printf("ODCO.sm\n");
load -force ODCP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODCP.sm xs ys;
printf("ODCP.sm\n");
load -force ODCW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODCW.sm xs ys;
printf("ODCW.sm\n");
load -force ODF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODF_.sm xs ys;
printf("ODF_.sm\n");
load -force ODFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODFe.sm xs ys;
printf("ODFe.sm\n");
load -force ODHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODHL.sm xs ys;
printf("ODHL.sm\n");
load -force ODMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODMg.sm xs ys;
printf("ODMg.sm\n");
load -force ODMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODMn.sm xs ys;
printf("ODMn.sm\n");
load -force ODN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODN0.sm xs ys;
printf("ODN0.sm\n");
load -force ODNA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODNA.sm xs ys;
printf("ODNA.sm\n");
load -force ODNC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODNC.sm xs ys;
printf("ODNC.sm\n");
load -force ODND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODND.sm xs ys;
printf("ODND.sm\n");
load -force ODNP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODNP.sm xs ys;
printf("ODNP.sm\n");
load -force ODNR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODNR.sm xs ys;
printf("ODNR.sm\n");
load -force ODNS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODNS.sm xs ys;
printf("ODNS.sm\n");
load -force ODOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODOA.sm xs ys;
printf("ODOA.sm\n");
load -force ODOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODOC.sm xs ys;
printf("ODOC.sm\n");
load -force ODOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODOD.sm xs ys;
printf("ODOD.sm\n");
load -force ODOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODOE.sm xs ys;
printf("ODOE.sm\n");
load -force ODOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODOR.sm xs ys;
printf("ODOR.sm\n");
load -force ODOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODOS.sm xs ys;
printf("ODOS.sm\n");
load -force ODP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODP_.sm xs ys;
printf("ODP_.sm\n");
load -force ODSA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODSA.sm xs ys;
printf("ODSA.sm\n");
load -force ODSD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODSD.sm xs ys;
printf("ODSD.sm\n");
load -force ODV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODV_.sm xs ys;
printf("ODV_.sm\n");
load -force ODZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODZn.sm xs ys;
printf("ODZn.sm\n");
load -force ODcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODcF.sm xs ys;
printf("ODcF.sm\n");
load -force ODcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii ODcP.sm xs ys;
printf("ODcP.sm\n");
load -force OWBr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWBr.sm xs ys;
printf("OWBr.sm\n");
load -force OWC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWC0.sm xs ys;
printf("OWC0.sm\n");
load -force OWC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWC3.sm xs ys;
printf("OWC3.sm\n");
load -force OWCF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWCF.sm xs ys;
printf("OWCF.sm\n");
load -force OWCL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWCL.sm xs ys;
printf("OWCL.sm\n");
load -force OWCN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWCN.sm xs ys;
printf("OWCN.sm\n");
load -force OWCO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWCO.sm xs ys;
printf("OWCO.sm\n");
load -force OWCP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWCP.sm xs ys;
printf("OWCP.sm\n");
load -force OWCW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWCW.sm xs ys;
printf("OWCW.sm\n");
load -force OWF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWF_.sm xs ys;
printf("OWF_.sm\n");
load -force OWFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWFe.sm xs ys;
printf("OWFe.sm\n");
load -force OWHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWHL.sm xs ys;
printf("OWHL.sm\n");
load -force OWMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWMg.sm xs ys;
printf("OWMg.sm\n");
load -force OWMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWMn.sm xs ys;
printf("OWMn.sm\n");
load -force OWN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWN0.sm xs ys;
printf("OWN0.sm\n");
load -force OWNA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWNA.sm xs ys;
printf("OWNA.sm\n");
load -force OWNC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWNC.sm xs ys;
printf("OWNC.sm\n");
load -force OWND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWND.sm xs ys;
printf("OWND.sm\n");
load -force OWNP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWNP.sm xs ys;
printf("OWNP.sm\n");
load -force OWNR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWNR.sm xs ys;
printf("OWNR.sm\n");
load -force OWNS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWNS.sm xs ys;
printf("OWNS.sm\n");
load -force OWOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWOA.sm xs ys;
printf("OWOA.sm\n");
load -force OWOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWOC.sm xs ys;
printf("OWOC.sm\n");
load -force OWOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWOD.sm xs ys;
printf("OWOD.sm\n");
load -force OWOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWOE.sm xs ys;
printf("OWOE.sm\n");
load -force OWOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWOR.sm xs ys;
printf("OWOR.sm\n");
load -force OWOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWOS.sm xs ys;
printf("OWOS.sm\n");
load -force OWP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWP_.sm xs ys;
printf("OWP_.sm\n");
load -force OWSA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWSA.sm xs ys;
printf("OWSA.sm\n");
load -force OWSD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWSD.sm xs ys;
printf("OWSD.sm\n");
load -force OWV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWV_.sm xs ys;
printf("OWV_.sm\n");
load -force OWZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWZn.sm xs ys;
printf("OWZn.sm\n");
load -force OWcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWcF.sm xs ys;
printf("OWcF.sm\n");
load -force OWcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii OWcP.sm xs ys;
printf("OWcP.sm\n");
load -force SABr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SABr.sm xs ys;
printf("SABr.sm\n");
load -force SAC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAC0.sm xs ys;
printf("SAC0.sm\n");
load -force SAC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAC3.sm xs ys;
printf("SAC3.sm\n");
load -force SACF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SACF.sm xs ys;
printf("SACF.sm\n");
load -force SACL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SACL.sm xs ys;
printf("SACL.sm\n");
load -force SACN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SACN.sm xs ys;
printf("SACN.sm\n");
load -force SACO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SACO.sm xs ys;
printf("SACO.sm\n");
load -force SACP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SACP.sm xs ys;
printf("SACP.sm\n");
load -force SACW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SACW.sm xs ys;
printf("SACW.sm\n");
load -force SAF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAF_.sm xs ys;
printf("SAF_.sm\n");
load -force SAFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAFe.sm xs ys;
printf("SAFe.sm\n");
load -force SAHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAHL.sm xs ys;
printf("SAHL.sm\n");
load -force SAMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAMg.sm xs ys;
printf("SAMg.sm\n");
load -force SAMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAMn.sm xs ys;
printf("SAMn.sm\n");
load -force SAN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAN0.sm xs ys;
printf("SAN0.sm\n");
load -force SANA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SANA.sm xs ys;
printf("SANA.sm\n");
load -force SANC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SANC.sm xs ys;
printf("SANC.sm\n");
load -force SAND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAND.sm xs ys;
printf("SAND.sm\n");
load -force SANP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SANP.sm xs ys;
printf("SANP.sm\n");
load -force SANR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SANR.sm xs ys;
printf("SANR.sm\n");
load -force SANS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SANS.sm xs ys;
printf("SANS.sm\n");
load -force SAOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAOA.sm xs ys;
printf("SAOA.sm\n");
load -force SAOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAOC.sm xs ys;
printf("SAOC.sm\n");
load -force SAOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAOD.sm xs ys;
printf("SAOD.sm\n");
load -force SAOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAOE.sm xs ys;
printf("SAOE.sm\n");
load -force SAOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAOR.sm xs ys;
printf("SAOR.sm\n");
load -force SAOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAOS.sm xs ys;
printf("SAOS.sm\n");
load -force SAP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAP_.sm xs ys;
printf("SAP_.sm\n");
load -force SASA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SASA.sm xs ys;
printf("SASA.sm\n");
load -force SASD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SASD.sm xs ys;
printf("SASD.sm\n");
load -force SAV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAV_.sm xs ys;
printf("SAV_.sm\n");
load -force SAZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAZn.sm xs ys;
printf("SAZn.sm\n");
load -force SAcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAcF.sm xs ys;
printf("SAcF.sm\n");
load -force SAcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SAcP.sm xs ys;
printf("SAcP.sm\n");
load -force SDBr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDBr.sm xs ys;
printf("SDBr.sm\n");
load -force SDC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDC0.sm xs ys;
printf("SDC0.sm\n");
load -force SDC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDC3.sm xs ys;
printf("SDC3.sm\n");
load -force SDCF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDCF.sm xs ys;
printf("SDCF.sm\n");
load -force SDCL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDCL.sm xs ys;
printf("SDCL.sm\n");
load -force SDCN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDCN.sm xs ys;
printf("SDCN.sm\n");
load -force SDCO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDCO.sm xs ys;
printf("SDCO.sm\n");
load -force SDCP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDCP.sm xs ys;
printf("SDCP.sm\n");
load -force SDCW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDCW.sm xs ys;
printf("SDCW.sm\n");
load -force SDF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDF_.sm xs ys;
printf("SDF_.sm\n");
load -force SDFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDFe.sm xs ys;
printf("SDFe.sm\n");
load -force SDHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDHL.sm xs ys;
printf("SDHL.sm\n");
load -force SDMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDMg.sm xs ys;
printf("SDMg.sm\n");
load -force SDMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDMn.sm xs ys;
printf("SDMn.sm\n");
load -force SDN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDN0.sm xs ys;
printf("SDN0.sm\n");
load -force SDNA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDNA.sm xs ys;
printf("SDNA.sm\n");
load -force SDNC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDNC.sm xs ys;
printf("SDNC.sm\n");
load -force SDND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDND.sm xs ys;
printf("SDND.sm\n");
load -force SDNP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDNP.sm xs ys;
printf("SDNP.sm\n");
load -force SDNR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDNR.sm xs ys;
printf("SDNR.sm\n");
load -force SDNS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDNS.sm xs ys;
printf("SDNS.sm\n");
load -force SDOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDOA.sm xs ys;
printf("SDOA.sm\n");
load -force SDOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDOC.sm xs ys;
printf("SDOC.sm\n");
load -force SDOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDOD.sm xs ys;
printf("SDOD.sm\n");
load -force SDOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDOE.sm xs ys;
printf("SDOE.sm\n");
load -force SDOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDOR.sm xs ys;
printf("SDOR.sm\n");
load -force SDOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDOS.sm xs ys;
printf("SDOS.sm\n");
load -force SDP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDP_.sm xs ys;
printf("SDP_.sm\n");
load -force SDSA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDSA.sm xs ys;
printf("SDSA.sm\n");
load -force SDSD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDSD.sm xs ys;
printf("SDSD.sm\n");
load -force SDV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDV_.sm xs ys;
printf("SDV_.sm\n");
load -force SDZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDZn.sm xs ys;
printf("SDZn.sm\n");
load -force SDcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDcF.sm xs ys;
printf("SDcF.sm\n");
load -force SDcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii SDcP.sm xs ys;
printf("SDcP.sm\n");
load -force cFBr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFBr.sm xs ys;
printf("cFBr.sm\n");
load -force cFC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFC0.sm xs ys;
printf("cFC0.sm\n");
load -force cFC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFC3.sm xs ys;
printf("cFC3.sm\n");
load -force cFCF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFCF.sm xs ys;
printf("cFCF.sm\n");
load -force cFCL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFCL.sm xs ys;
printf("cFCL.sm\n");
load -force cFCN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFCN.sm xs ys;
printf("cFCN.sm\n");
load -force cFCO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFCO.sm xs ys;
printf("cFCO.sm\n");
load -force cFCP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFCP.sm xs ys;
printf("cFCP.sm\n");
load -force cFCW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFCW.sm xs ys;
printf("cFCW.sm\n");
load -force cFF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFF_.sm xs ys;
printf("cFF_.sm\n");
load -force cFFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFFe.sm xs ys;
printf("cFFe.sm\n");
load -force cFHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFHL.sm xs ys;
printf("cFHL.sm\n");
load -force cFMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFMg.sm xs ys;
printf("cFMg.sm\n");
load -force cFMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFMn.sm xs ys;
printf("cFMn.sm\n");
load -force cFN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFN0.sm xs ys;
printf("cFN0.sm\n");
load -force cFNA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFNA.sm xs ys;
printf("cFNA.sm\n");
load -force cFNC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFNC.sm xs ys;
printf("cFNC.sm\n");
load -force cFND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFND.sm xs ys;
printf("cFND.sm\n");
load -force cFNP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFNP.sm xs ys;
printf("cFNP.sm\n");
load -force cFNR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFNR.sm xs ys;
printf("cFNR.sm\n");
load -force cFNS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFNS.sm xs ys;
printf("cFNS.sm\n");
load -force cFOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFOA.sm xs ys;
printf("cFOA.sm\n");
load -force cFOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFOC.sm xs ys;
printf("cFOC.sm\n");
load -force cFOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFOD.sm xs ys;
printf("cFOD.sm\n");
load -force cFOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFOE.sm xs ys;
printf("cFOE.sm\n");
load -force cFOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFOR.sm xs ys;
printf("cFOR.sm\n");
load -force cFOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFOS.sm xs ys;
printf("cFOS.sm\n");
load -force cFP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFP_.sm xs ys;
printf("cFP_.sm\n");
load -force cFSA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFSA.sm xs ys;
printf("cFSA.sm\n");
load -force cFSD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFSD.sm xs ys;
printf("cFSD.sm\n");
load -force cFV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFV_.sm xs ys;
printf("cFV_.sm\n");
load -force cFZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFZn.sm xs ys;
printf("cFZn.sm\n");
load -force cFcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFcF.sm xs ys;
printf("cFcF.sm\n");
load -force cFcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cFcP.sm xs ys;
printf("cFcP.sm\n");
load -force cPBr.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPBr.sm xs ys;
printf("cPBr.sm\n");
load -force cPC0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPC0.sm xs ys;
printf("cPC0.sm\n");
load -force cPC3.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPC3.sm xs ys;
printf("cPC3.sm\n");
load -force cPCF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPCF.sm xs ys;
printf("cPCF.sm\n");
load -force cPCL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPCL.sm xs ys;
printf("cPCL.sm\n");
load -force cPCN.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPCN.sm xs ys;
printf("cPCN.sm\n");
load -force cPCO.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPCO.sm xs ys;
printf("cPCO.sm\n");
load -force cPCP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPCP.sm xs ys;
printf("cPCP.sm\n");
load -force cPCW.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPCW.sm xs ys;
printf("cPCW.sm\n");
load -force cPF_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPF_.sm xs ys;
printf("cPF_.sm\n");
load -force cPFe.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPFe.sm xs ys;
printf("cPFe.sm\n");
load -force cPHL.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPHL.sm xs ys;
printf("cPHL.sm\n");
load -force cPMg.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPMg.sm xs ys;
printf("cPMg.sm\n");
load -force cPMn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPMn.sm xs ys;
printf("cPMn.sm\n");
load -force cPN0.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPN0.sm xs ys;
printf("cPN0.sm\n");
load -force cPNA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPNA.sm xs ys;
printf("cPNA.sm\n");
load -force cPNC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPNC.sm xs ys;
printf("cPNC.sm\n");
load -force cPND.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPND.sm xs ys;
printf("cPND.sm\n");
load -force cPNP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPNP.sm xs ys;
printf("cPNP.sm\n");
load -force cPNR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPNR.sm xs ys;
printf("cPNR.sm\n");
load -force cPNS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPNS.sm xs ys;
printf("cPNS.sm\n");
load -force cPOA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPOA.sm xs ys;
printf("cPOA.sm\n");
load -force cPOC.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPOC.sm xs ys;
printf("cPOC.sm\n");
load -force cPOD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPOD.sm xs ys;
printf("cPOD.sm\n");
load -force cPOE.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPOE.sm xs ys;
printf("cPOE.sm\n");
load -force cPOR.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPOR.sm xs ys;
printf("cPOR.sm\n");
load -force cPOS.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPOS.sm xs ys;
printf("cPOS.sm\n");
load -force cPP_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPP_.sm xs ys;
printf("cPP_.sm\n");
load -force cPSA.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPSA.sm xs ys;
printf("cPSA.sm\n");
load -force cPSD.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPSD.sm xs ys;
printf("cPSD.sm\n");
load -force cPV_.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPV_.sm xs ys;
printf("cPV_.sm\n");
load -force cPZn.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPZn.sm xs ys;
printf("cPZn.sm\n");
load -force cPcF.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPcF.sm xs ys;
printf("cPcF.sm\n");
load -force cPcP.dat;
[xs,ys]=savgol(x,y,5,5,4);
save -ascii cPcP.sm xs ys;
printf("cPcP.sm\n");
