from ftplib import FTP
import sys

# Get accession number from argument
accession = sys.argv[1]
prefix = accession[0:3]
middle = accession[3:6]
suffix = accession[6:9]

# NCBI SRA FTP site
ftp = FTP('ftp-trace.ncbi.nih.gov')

# Open stdout and transfer requested SRA as a file
ftp.login()
ftp.cwd('/sra/sra-instant/reads/ByRun/sra/' + 
        prefix + '/' +
        prefix + middle + '/' +
        prefix + middle + suffix + '/')
ftp.pwd()
ftp.retrbinary('RETR ' + prefix + middle + suffix + '.sra', sys.stdout)
ftp.quit()
