#!/usr/bin/perl
# v1.0.1 added log, and two different type of filtering (common / specific)
use strict;
use Getopt::Long;

my $list1_file;
my $list2_file;
my $log_file;
my $NB_COL=1;
my $TYPE = "common";
my %header;
my $nb_list1 = 0;
my $nb_list2 = 0;
my $nb_common = 0;


GetOptions (
"list1_file=s" => \$list1_file,
"list2_file=s" => \$list2_file,
"log_file=s" => \$log_file,
"type=s" => \$TYPE,
"nb_col=i" => \$NB_COL
) or die("Error in command line arguments\n");

open(L2, $list2_file)  or die("Can't open $list2_file\n");
while (my $line=<L2>){
	$nb_list2++;
	chomp($line);
	my @fields = split(/\s+/,$line);
	my $ref="";
	my $compt=0;
	while ($compt<$NB_COL){
		if ($ref){$ref.="\t";}
		$ref.=$fields[$compt];
		$compt++;
	}
	$header{$ref}=$line;
}
close (L2);


open(L1, $list1_file)  or die("Can't open $list1_file\n");
while (my $line=<L1>){
	$nb_list1++;
	my @fields = split(/\s+/,$line);
	my $ref="";
	my $compt=0;
	while ($compt<$NB_COL){
		if ($ref){$ref.="\t";}
		$ref.=$fields[$compt];
		$compt++;
	}
	# my $ref = "$fields[0]\t$fields[1]";

	if ($header{$ref}){
		$nb_common++;
		if ($TYPE eq "common"){
			print $line;
		}
		elsif ($TYPE eq "specific") {
		}
		else {
		}
	}
	else {
		if ($TYPE eq "common"){
		}
		elsif ($TYPE eq "specific") {
			print $line;
		}
		else {
		}
	}
	
}
my $nb_list1_only = $nb_list1 - $nb_common;
my $nb_list2_only = $nb_list2 - $nb_common;

close(L1);
open (LF,">$log_file") or die("Can't open $log_file\n");
print LF "\n####\t List Filtering \n";
print LF "#List 1 :\t$nb_list1 ($nb_list1_only)\n";
print LF "#List 2 :\t$nb_list2 ($nb_list2_only)\n";
print LF "#Common :\t$nb_common\n";
close (LF);

