#!/usr/bin/Rscript --vanilla --slave --no-site-file


#############################################################################
# WRAPPER for INTENSITY CHECK                                               #
#                                                                           #
#Script: Script_intensity_check.R                                           #
#Xml: xml_intensity_check.xml                                               #
#                                                                           #
#                                                                           #
# Input: Data Matrix, VariableMetadata, SampleMetadata                      #
# Output: VariableMetadata, Graphics                                        #
#                                                                           #
#                                                                           #
#############################################################################


library(batch) #necessary for parseCommandArgs function
args = parseCommandArgs(evaluate=FALSE) #interpretation of arguments given in command line as an R list of objects

source_local <- function(...){
  argv <- commandArgs(trailingOnly = FALSE)
  base_dir <- dirname(substring(argv[grep("--file=", argv)], 8))
  for(i in 1:length(list(...))){source(paste(base_dir, list(...)[[i]], sep="/"))}
}
#Import the different functions
source_local("Script_intensity_check.R", "RcheckLibrary.R")


if(length(args) < 7){ stop("NOT enough argument !!!") }

class_col <- NULL
test_fold <- NULL
class1 <- NULL
fold_frac <- NULL
logarithm <- NULL
if(args$method == "each_class"){ 
  class_col <- args$class_col
  test_fold <- args$test_fold
  if(args$test_fold == "Yes"){
    logarithm <- args$logarithm
  }
}
if(args$method == "one_class"){
  class_col <- args$class_col
  class1 <- args$class1
  test_fold <- args$test_fold
  if(args$test_fold == "Yes"){
    fold_frac <- args$fold_frac
    logarithm <- args$logarithm
  }
}

err_no_option <- NULL

if(((args$method == "no_class")&&(args$chosen_stat == "None"))||
   ((args$method != "no_class") && (args$chosen_stat == "None") && (test_fold == "No"))){
  err_no_option<- "You did not select any computational option. Program could not be executed."
  stop("\n- - - - - - - - -\n",err_no_option,"\n- - - - - - - - -\n")
}


#print args
cat("\n-------------------------------\nIntensity Check parameters:\n\n")
print(args)
cat("--------------------------------\n")

if(is.null(err_no_option)){

  intens_check(args$dataMatrix_in, args$sampleMetadata_in, args$variableMetadata_in, args$method, args$chosen_stat, 
             class_col, test_fold, class1, fold_frac, logarithm, args$variableMetadata_out, args$graphs_out)
}
  
sessionInfo()
cat("--------------------------------\n")

#delete the parameters to avoid the passage to the next tool in .RData image
rm(args)
