#! /usr/bin/perl -w

use strict;
use warnings;
use Text::ParseWords;

##Args are col range and output file name ONLY. no spaces!!

die "Please check arguments, probably spaces in column range!\n" unless @ARGV == 2;

my $colrange = $ARGV[0];
my $outputfile = $ARGV[1];

my @cols = split(/-/,$colrange);
die "Improper range format: probably missing - (hyphen) or it's at the end.\n" unless exists($cols[1]);

my @start = split('C',uc($cols[0]),2);
my @stop = split('C',uc($cols[1]),2);
die "Improper column format: missing preceding C for col number.\n" unless (exists($start[1]) && exists($stop[1]));

my $begin = $start[1];
my $end = $stop[1];

my $fhOut;
open ($fhOut, "> $outputfile");
for (my $i=$begin; $i<$end; $i++) {
	print $fhOut "c$i,";
}
print $fhOut "c$end\n";

close ($fhOut) or die "Cannot close output file\n";
