########################################################
#
# creation date : 27/06/16
# last modification : 22/10/16
# author : Dr Nicolas Beaume
# owner : IRRI
#
########################################################

# compute r2 by computing the classic formula
# compare the sum of square difference from target to prediciton
# to the sum of square difference from target to the mean of the target
computeR2 <- function(target, prediction) {
  sst <- sum((target-mean(target))^2)
  ssr <- sum((target-prediction)^2)
  return(1-ssr/sst)
}
############################ main #############################
# extract argument
cmd <- commandArgs(trailingOnly = T)
source(cmd[1])
# load target and prediction
phenotype <- read.table(phenotype, sep="\t", h=T)[,1] 
predicted <- read.table(predicted, sep = "\t", h=T)[,2]
# compute r2
cat(computeR2(phenotype, predicted), file=out)