########################################################
#
# creation date : 05/01/16
# last modification : 27/06/16
# author : Dr Nicolas Beaume
# owner : IRRI
#
########################################################


############################ main function #######################

# create fold by picking at random row indexes
createFolds <- function(nbObs, n) {
  # pick indexes
  index <- sample(1:n, size=nbObs, replace = T)
  # populate folds
  folds <- NULL
  for(i in 1:n) {
    folds <- c(folds, list(which(index==i)))
  }
  return(folds)
}

############################ main #############################
# load arguments
cmd <- commandArgs(trailingOnly = T)
source(cmd[1])
# load data and merge them
con = file(genotype)
genotype <- readLines(con = con, n = 1, ok=T)
close(con)
# fold creation
nObs <- nrow(read.table(genotype, sep="\t", h=T))
folds <- createFolds(nObs, as.numeric(n))
# save them into a rds and send back to galaxy the path
out <- paste(out,".rds",sep="")
saveRDS(folds, file=out)
cat(paste(out, "\n", sep=""))