#!/usr/bin/perl

use File::Temp qw/ tempfile tempdir /;
use File::Copy qw/ copy /;
use Cwd;

$collapsed_reads = $ARGV[0];
$bowtie_index_name = $ARGV[1];
$bowtie_files_path = $ARGV[2];
$arf_file = $ARGV[3];
$mirna_ref = $ARGV[4];
$mirna_other = $ARGV[5];
$precursors = $ARGV[6];
$file_path = $ARGV[7];
$input_name = $ARGV[8];

$csv_output = $ARGV[9];
$html_output = $ARGV[10];
$survey_output = $ARGV[11];
$mrd_output = $ARGV[12];

# the rest are options
$options = join (" ", @ARGV[13..$#ARGV]);

#point to correct bowtie index path
$basename = `basename $bowtie_index_name`;
chomp $basename;

# create the path used to house the pdfs
chomp $file_path;
system ("mkdir -p $file_path");

# do all the dirty work in a temp directory
$cwd = cwd();
$tempdir = tempdir(CLEANUP => 1);
chdir ($tempdir);

if ($mirna_ref eq "None") {$mirna_ref="none";}
if ($mirna_other eq "None") {$mirna_other="none";}
if ($precursors eq "None") {$precursors="none";}

$ret_mirdeep2 = `miRDeep2.pl $collapsed_reads $bowtie_files_path/$basename $arf_file $mirna_ref $mirna_other $precursors -v $options 2> /dev/null`;
system ("cp $tempdir/pdfs*/*.pdf $file_path");

$csv_file = `ls $tempdir/result*.csv`;
chomp $csv_file;
if ($csv_file eq "") {die "Error: Cannot find csv result file in dir $tempdir\n";}

$html_file = `ls $tempdir/result*.html`;
chomp $html_file;
if ($html_file eq "") {die "Error: Cannot find html result file in dir $tempdir\n";}

$survey_file = `ls $tempdir/mirdeep_runs/run*/survey.csv`;
chomp $survey_file;
if ($survey_file eq "") {die "Error: Cannot find survey result file in dir $tempdir\n";}

$mrd_file = `ls $tempdir/mirdeep_runs/run*/output.mrd`;
chomp $mrd_file;
if ($mrd_file eq "") {die "Error: Cannot find hairpin result file in dir $tempdir\n";}

# replacing mirdeep created links with relative links in galaxy
system ("sed -r -i 's/file:\\/\\/.+\\/(.+\\.pdf)/\\1/g' $html_file");

copy ($csv_file, $csv_output);
copy ($html_file, $html_output);
copy ($survey_file, $survey_output);
copy ($mrd_file, $mrd_output);

chdir($cwd);
