package datastructures;

import java.io.File;
import java.io.IOException;
import java.lang.InterruptedException;
import java.util.Scanner;
import java.util.Vector;

public class Read implements Comparable<Object> {

	String query;
	int flag;
	String rname;
	int pos;
	int mapq;
	String cigar;
	String rnext;
	int pnext;
	int tlen;
	String seq;
	String qual;
	Vector<String> optional;

	public Read(String line) {
		Scanner s = new Scanner(line);
		query = s.next();
		flag = s.nextInt();
		rname = s.next();
		pos = s.nextInt();
		mapq = s.nextInt();
		cigar = s.next();
		rnext = s.next();
		pnext = s.nextInt();
		tlen = s.nextInt();
		seq = s.next();
		qual = s.next();
		if (s.hasNext()) {
			optional = new Vector<String>();
			while (s.hasNext()) {
				optional.add(s.next());
			}
		}
	}

	public String getRname() {
		return rname;
	}

	public int getPos() {
		return pos;
	}

	@Override
	public int compareTo(Object o) {
		return 0;
	}

	public static void sort(File input) {
		Runtime rt = Runtime.getRuntime();
		try {
			String 	rawOutput = input.getAbsolutePath(), 
					tmpD = input.getParentFile().getAbsolutePath(), 
					outputName = input.getName(), 
					pathname = 	input.getParentFile().getAbsolutePath() + "/" + 
								outputName + "Sorted";
			
			input = new File(pathname);
			
			if (!input.exists())
				input.createNewFile();

			String command = "sort -k3,3 -k4n,4 -T " + tmpD + " " + rawOutput+" > "+pathname;
			Process p = rt.exec(command);
			try{p.waitFor();}
			catch(InterruptedException e){e.printStackTrace();}
			System.out.println("Fertig");
			/*			Scanner ps = new Scanner(p.getInputStream());
			FileWriter fw = new FileWriter(input);

			while (ps.hasNextLine()) {
				String nextLine = ps.nextLine();
				fw.write(nextLine + "\r\n");
			}

			fw.close(); */

			new File(rawOutput).delete();
			new File(pathname).renameTo(new File(rawOutput));
			System.out.println("File " + new File(rawOutput).getAbsolutePath()
					+ " sorted\n");

		} catch (IOException e1) {
			e1.printStackTrace();
		}
	}
}
