package datastructures;

import java.util.Scanner;
import exceptions.ChromosomeFormatException;
import exceptions.ChromosomeNotFoundException;
import exceptions.RangeFormatException;
import exceptions.RangeLimitNotFoundException;

/**
 * Represents a read Line from the read alignment file.
 * 
 * @author Ali Abdallah
 * @version 22.07.2011
 * @since Java 1.6
 */
public class ReducedReadLine implements Line{

	String line;
	String rName;
	String chrom;
	int start, end;
	
	public ReducedReadLine(String line) throws ChromosomeFormatException, 
										ChromosomeNotFoundException, 
										RangeFormatException, 
										RangeLimitNotFoundException{
		this.line = line;
		Scanner s = new Scanner(line);
		if(s.hasNext())
			rName = s.next();
		if(s.hasNext()){
			chrom = s.next(); 
			if(!(chrom.toLowerCase().startsWith("chr") || chrom.equals("*")))
				throw new ChromosomeFormatException(chrom);
		}
		else
			throw new ChromosomeNotFoundException();
		
		if(s.hasNextInt()){
			start = s.nextInt();
			if(start < 0){
				throw new RangeFormatException("Start position must be a positive integer.");
			}
		}
		else if(!s.hasNext())
			throw new RangeLimitNotFoundException("No range start found!");
		else	
			throw new RangeFormatException("Found: "+start+". Start position ist not an integer. " +
									 "It must be a positive integer.");
		
		if(s.hasNextInt()){
			end = s.nextInt();
			if(end < 0){
				throw new RangeFormatException("End position must be a positive integer.");
			}
		}
		else if(!s.hasNext())
			throw new RangeLimitNotFoundException("No range end found!");
		else	
			throw new RangeFormatException("Found: "+end+". End position ist not an integer. " +
									 "It must be a positive integer.");
	}
	
	public String chrom(){
		return chrom;
	}
	
	public int start(){
		return start;
	}
	
	public int end(){
		return end;
	}
	
	public String toString(){
		return line;
	}
	
	public boolean isForwardRead(){
		return start <= end;
	}

	public String name() {
		// TODO Auto-generated method stub
		return rName;
	}
	
}
