package datastructures;

import java.util.Scanner;

/**
 * Represents a read line from the read alignment file.
 * 
 * @author Ali Abdallah
 * @version 03.08.2011
 * @since Java 1.6
 */

public class ReadLine implements Line {
	
	String 
	/**
	 * Query (pair) name.
	 */
	name, 
	/**
	 * Reference sequence name.
	 */
	chrom;
	/**
	 * Start position of the read.
	 */
	int start, 
	/**
	 * End Position of the read.
	 */
	end, 
	/**
	 * Length of the read.
	 */
	length;
	
	public ReadLine(String line){
		// line format:
		// qname flag rname pos mapq cigar mrnm mpos isize seq qual tag
		Scanner s = new Scanner(line);
		name = s.next();
		s.next();
		chrom = s.next();
		start = s.nextInt();
		s.next(); s.next();s.next();s.next();s.next();
		length = s.next().length();
		end = start+length-1;
	}
	
	public String name(){
		return name;
	}
	
	public String chrom() {
		return chrom;
	}

	public int end() {
		return end;
	}

	public int start() {
		return start;
	}

	public int length(){
		return length;
	}
	
	public String toString(){
		return name+"\t"+chrom+"\t"+start+"\t"+end;
	}
}
