options(show.error.messages=F, error=function(){cat(geterrmessage(),file=stderr());q("no",1,F)})
sink(stdout(), type = "message")
suppressWarnings(suppressMessages(library("batch")))
suppressWarnings(suppressMessages(library(GEOquery)))
listArguments = parseCommandArgs(evaluate=FALSE)
GeoCode=listArguments[["GeoCode"]]
GeoCode=toupper(GeoCode)
gethelp.df =suppressMessages(suppressWarnings(tryCatch(eList <- getGEOSuppFiles(GeoCode), error = function(cond)"skip")))
if(is.null(gethelp.df)){
  gethelp.df =suppressMessages(suppressWarnings(tryCatch(eList <- getGEOSuppFiles(GeoCode), error = function(cond)"skip")))
}
if(is.null(gethelp.df)){
  write("GeoCode with no raw data, choose another code or retry.", stderr())
}else{
  if(is.data.frame(gethelp.df)==TRUE){
    rawdata=rownames(eList)[grep('RAW',rownames(eList))][1]
    untar(rawdata, exdir = 'CEL')
     if (file.exists(rawdata)) {
        file.remove(rawdata)
     }
  }else{
    if(gethelp.df=="skip"){
      write("Network trouble, try again or Check your geoCode.", stderr())
      quit(status=2)
    }else{
      write("GeoCode with no raw data, choose another code or retry.", stderr())
      quit(status=3)
    }
  }
}

