AffymetrixPreprocessingFunction<-function(path="",rawdata,backgroundcorrection_method,normalization_method,summary_method,datasetsource="",listfullnames="")
{
  colnames(exprs(rawdata))<-listfullnames
  data.bg<-bg.correct(rawdata, method=backgroundcorrection_method)
  data.norm<-normalize(data.bg, method=normalization_method)
  data.sm<-threestep(data.norm, background=F, normalize=F,summary.method=summary_method)
  data_matrix=exprs(data.sm)  
  sampleNames(data.sm)<-listfullnames
  if(datasetsource=="extern"){
  colnames(data_matrix)<-listfullnames
  data.sm=ExpressionSet(data_matrix,phenoData=phenoData(data.sm),featureData=featureData(data.sm),
  experimentData=experimentData(data.sm),annotation=annotation(data.sm),protocolData=protocolData(data.sm))
   write.table(format(exprs(data.sm), justify="right"),sep="\t", quote=FALSE,
            row.names=T, col.names=T,file="Matrix.Data.tsv")
  }else{
  colnames(data_matrix)<-designo$sample
  data.sm=ExpressionSet(data_matrix,phenoData=phenoData(data.sm),featureData=featureData(data.sm),
  experimentData=experimentData(data.sm),annotation=annotation(data.sm),protocolData=protocolData(data.sm))
  write.table(format(exprs(data.sm), justify="right"),sep="\t", quote=FALSE,
            row.names=T, col.names=T,file="Matrix.Data.tsv")
  }
  installed<-as.data.frame(installed.packages())
  lbraries=paste(annotation(data.sm),"db",sep='.')
  if(!lbraries%in%installed$Package){
  suppressWarnings(suppressMessages(require("BiocManager", quietly = TRUE)))
  BiocManager::install(lbraries[!lbraries%in%installed$Package])}
  
  suppressWarnings(suppressMessages(library(lbraries,character.only = TRUE)))
  
  symbol<-getSYMBOL(rownames(exprs(data.sm)), annotation(data.sm))
  return(list(data.bg=data.bg,data.norm=data.norm,data.sm=data.sm,matrix_data=exprs(data.sm),symbol=symbol))
  
  }
