options(show.error.messages=F, error=function(){cat(geterrmessage(),file=stderr());q("no",1,F)})
sink(stdout(), type = "message")
suppressWarnings(suppressMessages(library(limma)))
suppressWarnings(suppressMessages(library(marray)))
suppressWarnings(suppressMessages(library(batch)))
suppressWarnings(suppressMessages(library(IDPmisc)))
suppressWarnings(suppressMessages(library(affy)))
suppressWarnings(suppressMessages(library(markdown)))
suppressWarnings(suppressMessages(library(knitr)))
source_local <- function(fname){
    argv <- commandArgs(trailingOnly = FALSE)
    base_dir <- dirname(substring(argv[grep("--file=", argv)], 8))
    source(paste(base_dir, fname, sep="/"))
}
file_path <- function(fname){
  argv <- commandArgs(trailingOnly = FALSE)
  base_dir <- dirname(substring(argv[grep("--file=", argv)], 8))
  pato <- paste(base_dir, fname, sep="/")
  return(pato)
}
base_dir <- function(){
  argv <- commandArgs(trailingOnly = FALSE)
  base_dir <- dirname(substring(argv[grep("--file=", argv)], 8))
  return(base_dir)
}
source_local("Make_matrix_two_channels.R")
source_local("GenePix_Two_Colors_Preprocessing_Functions.R")
listArguments = parseCommandArgs(evaluate=FALSE)
print(listArguments)
load(listArguments[["image"]])
names(listArguments)[which(names(listArguments)=="image")]="data"
listArguments[["data"]]=MicroArray_Object$RFile
thefunction=listArguments[["thefunction"]]
listArguments[["thefunction"]]=NULL
h=listArguments[["h"]]
listArguments[["h"]]=NULL
w=listArguments[["w"]]
listArguments[["w"]]=NULL
# print(thefunction)
if(datasetsource=="intern"){
designo<-MicroArray_Object$designo
}
Prepro_object<-do.call(thefunction,listArguments)
designo<-Prepro_object$designo
RGNBA=RG.MA(Prepro_object$dataNBA)
if(datasetsource=="extern"){
colnames(MicroArray_Object[[1]]$G)<-listcelsnames[-1]
colnames(MicroArray_Object[[1]]$R)<-listcelsnames[-1]
colnames(Prepro_object$dataBG$G)<-listcelsnames[-1]
colnames(Prepro_object$dataBG$R)<-listcelsnames[-1]
colnames(Prepro_object$dataNWA$G)<-listcelsnames[-1]
colnames(Prepro_object$dataNWA$R)<-listcelsnames[-1]
colnames(RGNBA$G)<-listcelsnames[-1]
colnames(RGNBA$R)<-listcelsnames[-1]

}
par(las=2,mar=c(15,2,1,1))
png(filename ="boxplot_before_BG.png",width = w, height = h, units = "px", pointsize = 14, bg = "white")
old.par <- par(mfrow=c(1, 2))
boxplot(log2(na.omit(as.data.frame(MicroArray_Object[[1]]$R))), main="Boxplot of log2(R intensities) before BGC",col="red",ylab="log2(R intensities)",xlab="",las=2,mar=c(15,2,1,1))
boxplot(log2(na.omit(as.data.frame(MicroArray_Object[[1]]$G))), main="Boxplot of log2(G intensities) before BGC",col="green",ylab="log2(G intensities)",xlab="",las=2,mar=c(15,2,1,1))
par(old.par)
dev.off()

png(filename ="boxplot_after_BG.png",width = w, height = h, units = "px", pointsize = 14, bg = "white")
old.par <- par(mfrow=c(1, 2))
boxplot(log2(na.omit(as.data.frame(Prepro_object$dataBG$R))), main="Boxplot of log2(R intensities) After BGC",col="red",ylab="log2(R intensities)",xlab="",las=2,mar=c(15,2,1,1))
boxplot(log2(na.omit(as.data.frame(Prepro_object$dataBG$G))), main="Boxplot of log2(G intensities) After BGC",col="green",ylab="log2(G intensities)",xlab="",las=2,mar=c(15,2,1,1))
par(old.par)
dev.off()

png(filename ="boxplot_after_NWA.png",width = w, height = h, units = "px", pointsize = 14, bg = "white")
old.par <- par(mfrow=c(1, 2))
boxplot(log2(na.omit(as.data.frame(Prepro_object$dataNWA$R))), main="Boxplot of log2(R intensities) After NWA",col="red",ylab="log2(R intensities)",xlab="",las=2,mar=c(15,2,1,1))
boxplot(log2(na.omit(as.data.frame(Prepro_object$dataNWA$G))), main="Boxplot of log2(G intensities) After NWA",col="green",ylab="log2(G intensities)",xlab="",las=2,mar=c(15,2,1,1))
par(old.par)
dev.off()
png(filename ="boxplot_after_NBA.png",width = w, height = h, units = "px", pointsize = 14, bg = "white")
old.par <- par(mfrow=c(1, 2))
boxplot(log2(na.omit(as.data.frame(RGNBA$R))), main="Boxplot of log2(R intensities) After NBA",col="red",ylab="log2(R intensities)",xlab="",las=2,mar=c(15,2,1,1))
boxplot(log2(na.omit(as.data.frame(RGNBA$G))), main="Boxplot of log2(G intensities) After NBA",col="green",ylab="log2(G intensities)",xlab="",las=2,mar=c(15,2,1,1))
par(old.par)
dev.off()
png(filename ="MA_plot.png",width = w, height = h)
ma.plot(na.omit(Prepro_object$dataNBA$A), na.omit(Prepro_object$dataNBA$M), 
        show.statistics = F, span = 2/3, family.loess = "gaussian",
        cex = 2, plot.method = as.character("smoothScatter"),
        add.loess = TRUE, lwd = 1, lty = 1, loess.col = "red",main="MA plot")

dev.off()
png(filename = "densities_plot_before_BG.png",width = w, height = h)
plotDensities(MicroArray_Object[[1]],log=T)
dev.off()

png(filename = "densities_plot_after_BG.png",width = w, height = h)
plotDensities(Prepro_object$dataBG,log=T)
dev.off()

png(filename = "densities_plot_after_NWA.png",width = w, height = h)
plotDensities(Prepro_object$dataNWA,log=T)
dev.off()

png(filename = "densities_plot_after_NBA.png",width = w, height = h)
plotDensities(Prepro_object$dataNBA,log=T)
dev.off()
TwoColorsRmd=file_path("TwoColors.Rmd")
Style=file_path("look.css")
suppressWarnings(suppressMessages(knit2html(TwoColorsRmd,output="PreprocessingPlots.html",quiet = T, stylesheet=Style)))
rm(listArguments)
save.image(file="MicroArray.Preprocessing.RData")
