from galaxy.datatypes import data
from galaxy.datatypes.metadata import MetadataElement
from galaxy.datatypes.binary import Binary
from galaxy.datatypes import metadata
from galaxy.datatypes.sniff import *
import tarfile

class Tar( Binary ):
	"""Class describing a BAM binary file"""
	file_ext = "tar"
	def sniff( self, filename ):
		try:
			if tarfile.is_tarfile(filename):
				return True
		except:
			return False

	def set_peek( self, dataset, is_multi_byte=False ):
		if not dataset.dataset.purged:
			dataset.peek  = "Tar file"
			dataset.blurb = data.nice_size( dataset.get_size() )
		else:
			dataset.peek = 'file does not exist'
			dataset.blurb = 'file purged from disk'

	def display_peek( self, dataset ):
		try:
			return dataset.peek
		except:
			return "Tar file" 