#!/bin/bash

echo $@

command=''
filetype=$1
input=$2
label=$3
echo label is $label
if [ $label != 'None' ]; then
 labelformatted=${label//,/-}
 command+=', 'label=$labelformatted
fi
output=$4
outputid=$5
outputpath=$6
calc=$7
advanced=$8
if [ $advanced == True ]; then
     cabund=$9
     abund=${10}
     if [ $cabund == True ]; then
     	command+=', 'abund=$abund
     fi
     csize=${11}
     size=${12}
     if [ $csize == True ]; then
        if [ $size != 0 ]; then
           command+=', 'size=$size
       fi 
     fi
     cfreq=${13}
     freq=${14}
     if [ $cfreq == True ]; then
        command+=', 'freq=$freq
        echo $command
     fi
fi


echo path: $outputpath id: $outputid
## get filename only remove the extension
file="${input%.*}"
echo `cp $input $file'.'$filetype`
inputfile=$file'.'$filetype
calculator=${calc//,/-}
IFS=',' read -a sum_calc <<< "$calc"
for element in "${sum_calc[@]}"
do
    if [[ "$element" != "nseqs" ]] && [[ "$element" != "coverage" ]] && [[ "$element" != "sobs" ]]
    then
      sum_calculator+='-'$element
    fi
done
#echo "collect.single($filetype=$inputfile, calc=$calc)"
## use Mothur collect.single to calculate collector's curve - alpha diversity
#mothur "#summary.single($filetype=$inputfile, calc=$calculator$command)"
mothur "#summary.single($filetype=$inputfile, calc=nseqs-coverage-sobs$sum_calculator$command)"
mothur "#collect.single($filetype=$inputfile, calc=$calculator$command)" 
IFS=, read -a calcs <<< "${calc}"
count=0
##copy summary as main output
echo `cp $file'.summary' $output`
#copy calc files into directory
for i in "${calcs[@]}"
do
   #if [ $count == 0 ]; then
   #   echo `cp $file'.'$i $output`
   #else
      echo `cp $file'.'$i $outputpath'/primary_'$outputid'_'$i'_visible_tabular'`
   #fi
   let count+=1
done
