/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.List;
import java.util.NoSuchElementException;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

class IntervalOverlapFilteringIterator
implements CloseableIterator<SAMRecord> {
    private CloseableIterator<SAMRecord> iterator;
    private SAMRecord nextRead;
    private boolean keepOnlyUnmappedReads;
    private int[] intervalContigIndices;
    private int[] intervalStarts;
    private int[] intervalEnds;
    private int currentBound = 0;

    public IntervalOverlapFilteringIterator(CloseableIterator<SAMRecord> iterator, List<GenomeLoc> intervals) {
        this.iterator = iterator;
        boolean foundMappedIntervals = false;
        for (GenomeLoc location : intervals) {
            if (!GenomeLoc.isUnmapped(location)) {
                foundMappedIntervals = true;
            }
            this.keepOnlyUnmappedReads |= GenomeLoc.isUnmapped(location);
        }
        if (foundMappedIntervals) {
            if (this.keepOnlyUnmappedReads) {
                throw new ReviewedStingException("Tried to apply IntervalOverlapFilteringIterator to a mixed of mapped and unmapped intervals.  Please apply this filter to only mapped or only unmapped reads");
            }
            this.intervalContigIndices = new int[intervals.size()];
            this.intervalStarts = new int[intervals.size()];
            this.intervalEnds = new int[intervals.size()];
            int i = 0;
            for (GenomeLoc interval : intervals) {
                this.intervalContigIndices[i] = interval.getContigIndex();
                this.intervalStarts[i] = interval.getStart();
                this.intervalEnds[i] = interval.getStop();
                ++i;
            }
        }
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.nextRead != null;
    }

    @Override
    public SAMRecord next() {
        if (this.nextRead == null) {
            throw new NoSuchElementException("No more reads left in this iterator.");
        }
        SAMRecord currentRead = this.nextRead;
        this.advance();
        return currentRead;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from an IntervalOverlapFilteringIterator");
    }

    @Override
    public void close() {
        this.iterator.close();
    }

    private void advance() {
        this.nextRead = null;
        if (!this.iterator.hasNext()) {
            return;
        }
        SAMRecord candidateRead = (SAMRecord)this.iterator.next();
        while (this.nextRead == null && (this.keepOnlyUnmappedReads || this.currentBound < this.intervalStarts.length)) {
            if (!this.keepOnlyUnmappedReads) {
                if (this.readEndsOnOrAfterStartingBound(candidateRead)) {
                    if (this.readStartsOnOrBeforeEndingBound(candidateRead)) {
                        this.nextRead = candidateRead;
                        break;
                    }
                    ++this.currentBound;
                    continue;
                }
            } else if (candidateRead.getReadUnmappedFlag()) {
                this.nextRead = candidateRead;
                break;
            }
            if (!this.iterator.hasNext()) break;
            candidateRead = (SAMRecord)this.iterator.next();
        }
    }

    private boolean readEndsOnOrAfterStartingBound(SAMRecord read) {
        return read.getReferenceIndex() > this.intervalContigIndices[this.currentBound] || read.getReferenceIndex() == this.intervalContigIndices[this.currentBound] && (read.getAlignmentEnd() >= this.intervalStarts[this.currentBound] || read.getReadUnmappedFlag() && read.getAlignmentStart() >= this.intervalStarts[this.currentBound]);
    }

    private boolean readStartsOnOrBeforeEndingBound(SAMRecord read) {
        return read.getReferenceIndex() < this.intervalContigIndices[this.currentBound] || read.getReferenceIndex() == this.intervalContigIndices[this.currentBound] && read.getAlignmentStart() <= this.intervalEnds[this.currentBound];
    }
}

