/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.fragments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalDataManager;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.fragments.FragmentCollection;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;

public class FragmentUtils {
    private static final ReadGetter<GATKSAMRecord> SamRecordGetter = new ReadGetter<GATKSAMRecord>(){

        @Override
        public GATKSAMRecord get(GATKSAMRecord object) {
            return object;
        }
    };
    private static final ReadGetter<PileupElement> PileupElementGetter = new ReadGetter<PileupElement>(){

        @Override
        public GATKSAMRecord get(PileupElement object) {
            return object.getRead();
        }
    };

    private FragmentUtils() {
    }

    private static final <T> FragmentCollection<T> create(Iterable<T> readContainingObjects, int nElements, ReadGetter<T> getter) {
        Collection singletons = null;
        ArrayList<List<Object>> overlapping = null;
        HashMap<String, T> nameMap = null;
        int lastStart = -1;
        for (T p : readContainingObjects) {
            Object pe1;
            GATKSAMRecord read = getter.get(p);
            if (read.getAlignmentStart() < lastStart) {
                throw new IllegalArgumentException(String.format("FragmentUtils.create assumes that the incoming objects are ordered by SAMRecord alignment start, but saw a read %s with alignment start %d before the previous start %d", read.getSAMString(), read.getAlignmentStart(), lastStart));
            }
            lastStart = read.getAlignmentStart();
            int mateStart = read.getMateAlignmentStart();
            if (mateStart == 0 || mateStart > read.getAlignmentEnd()) {
                if (singletons == null) {
                    singletons = new ArrayList(nElements);
                }
                singletons.add(p);
                continue;
            }
            String readName = ((SAMRecord)read).getReadName();
            Object v0 = pe1 = nameMap == null ? null : nameMap.get(readName);
            if (pe1 != null) {
                if (overlapping == null) {
                    overlapping = new ArrayList<List<Object>>();
                }
                overlapping.add(Arrays.asList(pe1, p));
                nameMap.remove(readName);
                continue;
            }
            if (nameMap == null) {
                nameMap = new HashMap<String, T>(nElements);
            }
            nameMap.put(readName, p);
        }
        if (nameMap != null && !nameMap.isEmpty()) {
            if (singletons == null) {
                singletons = nameMap.values();
            } else {
                singletons.addAll(nameMap.values());
            }
        }
        return new FragmentCollection(singletons, overlapping);
    }

    public static final FragmentCollection<PileupElement> create(ReadBackedPileup rbp) {
        return FragmentUtils.create(rbp, rbp.getNumberOfElements(), PileupElementGetter);
    }

    public static final FragmentCollection<GATKSAMRecord> create(List<GATKSAMRecord> reads) {
        return FragmentUtils.create(reads, reads.size(), SamRecordGetter);
    }

    public static final List<GATKSAMRecord> mergeOverlappingPairedFragments(List<GATKSAMRecord> overlappingPair) {
        int iii;
        int MIN_QUAL_BAD_OVERLAP = 16;
        if (overlappingPair.size() != 2) {
            throw new ReviewedStingException("Found overlapping pair with " + overlappingPair.size() + " reads, but expecting exactly 2.");
        }
        GATKSAMRecord firstRead = overlappingPair.get(0);
        GATKSAMRecord secondRead = overlappingPair.get(1);
        if (secondRead.getUnclippedStart() > firstRead.getUnclippedEnd() || secondRead.getUnclippedStart() < firstRead.getUnclippedStart() || secondRead.getUnclippedEnd() < firstRead.getUnclippedEnd()) {
            firstRead = overlappingPair.get(1);
            secondRead = overlappingPair.get(0);
        }
        if (secondRead.getUnclippedStart() > firstRead.getUnclippedEnd() || secondRead.getUnclippedStart() < firstRead.getUnclippedStart() || secondRead.getUnclippedEnd() < firstRead.getUnclippedEnd()) {
            return overlappingPair;
        }
        if (firstRead.getCigarString().contains("I") || firstRead.getCigarString().contains("D") || secondRead.getCigarString().contains("I") || secondRead.getCigarString().contains("D")) {
            return overlappingPair;
        }
        Pair<Integer, Boolean> pair = ReadUtils.getReadCoordinateForReferenceCoordinate(firstRead, secondRead.getSoftStart());
        int firstReadStop = pair.getSecond() != false ? pair.getFirst() + 1 : pair.getFirst();
        int numBases = firstReadStop + secondRead.getReadLength();
        byte[] bases = new byte[numBases];
        byte[] quals = new byte[numBases];
        byte[] insertionQuals = new byte[numBases];
        byte[] deletionQuals = new byte[numBases];
        byte[] firstReadBases = firstRead.getReadBases();
        byte[] firstReadQuals = firstRead.getBaseQualities();
        byte[] secondReadBases = secondRead.getReadBases();
        byte[] secondReadQuals = secondRead.getBaseQualities();
        for (iii = 0; iii < firstReadStop; ++iii) {
            bases[iii] = firstReadBases[iii];
            quals[iii] = firstReadQuals[iii];
        }
        for (iii = firstReadStop; iii < firstRead.getReadLength(); ++iii) {
            if (firstReadQuals[iii] > 16 && secondReadQuals[iii - firstReadStop] > 16 && firstReadBases[iii] != secondReadBases[iii - firstReadStop]) {
                return overlappingPair;
            }
            bases[iii] = firstReadQuals[iii] > secondReadQuals[iii - firstReadStop] ? firstReadBases[iii] : secondReadBases[iii - firstReadStop];
            quals[iii] = firstReadQuals[iii] > secondReadQuals[iii - firstReadStop] ? firstReadQuals[iii] : secondReadQuals[iii - firstReadStop];
        }
        for (iii = firstRead.getReadLength(); iii < numBases; ++iii) {
            bases[iii] = secondReadBases[iii - firstReadStop];
            quals[iii] = secondReadQuals[iii - firstReadStop];
        }
        GATKSAMRecord returnRead = new GATKSAMRecord(firstRead.getHeader());
        returnRead.setAlignmentStart(firstRead.getUnclippedStart());
        returnRead.setReadBases(bases);
        returnRead.setBaseQualities(quals);
        returnRead.setReadGroup(firstRead.getReadGroup());
        returnRead.setReferenceName(firstRead.getReferenceName());
        CigarElement c = new CigarElement(bases.length, CigarOperator.M);
        ArrayList<CigarElement> cList = new ArrayList<CigarElement>();
        cList.add(c);
        returnRead.setCigar(new Cigar(cList));
        returnRead.setMappingQuality(firstRead.getMappingQuality());
        if (firstRead.hasBaseIndelQualities() || secondRead.hasBaseIndelQualities()) {
            int iii2;
            byte[] firstReadInsertionQuals = firstRead.getBaseInsertionQualities();
            byte[] firstReadDeletionQuals = firstRead.getBaseDeletionQualities();
            byte[] secondReadInsertionQuals = secondRead.getBaseInsertionQualities();
            byte[] secondReadDeletionQuals = secondRead.getBaseDeletionQualities();
            for (iii2 = 0; iii2 < firstReadStop; ++iii2) {
                insertionQuals[iii2] = firstReadInsertionQuals[iii2];
                deletionQuals[iii2] = firstReadDeletionQuals[iii2];
            }
            for (iii2 = firstReadStop; iii2 < firstRead.getReadLength(); ++iii2) {
                insertionQuals[iii2] = firstReadQuals[iii2] > secondReadQuals[iii2 - firstReadStop] ? firstReadInsertionQuals[iii2] : secondReadInsertionQuals[iii2 - firstReadStop];
                deletionQuals[iii2] = firstReadQuals[iii2] > secondReadQuals[iii2 - firstReadStop] ? firstReadDeletionQuals[iii2] : secondReadDeletionQuals[iii2 - firstReadStop];
            }
            for (iii2 = firstRead.getReadLength(); iii2 < numBases; ++iii2) {
                insertionQuals[iii2] = secondReadInsertionQuals[iii2 - firstReadStop];
                deletionQuals[iii2] = secondReadDeletionQuals[iii2 - firstReadStop];
            }
            returnRead.setBaseQualities(insertionQuals, RecalDataManager.BaseRecalibrationType.BASE_INSERTION);
            returnRead.setBaseQualities(deletionQuals, RecalDataManager.BaseRecalibrationType.BASE_DELETION);
        }
        ArrayList<GATKSAMRecord> returnList = new ArrayList<GATKSAMRecord>();
        returnList.add(returnRead);
        return returnList;
    }

    public static interface ReadGetter<T> {
        public GATKSAMRecord get(T var1);
    }
}

